/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.economy.service;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.economy.api.CommonEconomy;
import eu.pb4.common.economy.api.EconomyAccount;
import eu.pb4.common.economy.api.EconomyCurrency;
import eu.pb4.common.economy.api.EconomyProvider;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.OfflineGameProfile;
import io.github.sakurawald.fuji.module.initializer.economy.EconomyInitializer;
import io.github.sakurawald.fuji.module.initializer.economy.config.structure.CustomEconomyAccountNode;
import io.github.sakurawald.fuji.module.initializer.economy.config.structure.CustomEconomyCurrencyNode;
import io.github.sakurawald.fuji.module.initializer.economy.structure.CustomEconomyCurrency;
import io.github.sakurawald.fuji.module.initializer.economy.structure.CustomEconomyProvider;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class EconomyService {
    public static Collection<EconomyCurrency> getServerCurrencies() {
        MinecraftServer server = ServerHelper.getServer();
        return CommonEconomy.getCurrencies((MinecraftServer)server);
    }

    public static Collection<class_2960> getServerCurrencyIds() {
        return EconomyService.getServerCurrencies().stream().map(EconomyCurrency::id).toList();
    }

    public static boolean isCurrencyInstalledOnThisServer(class_2960 currencyId) {
        return EconomyService.getServerCurrencyIds().stream().anyMatch(it -> it.equals((Object)currencyId));
    }

    public static Collection<EconomyProvider> getProviders() {
        return CommonEconomy.providers();
    }

    @NotNull
    public static Collection<EconomyAccount> getUserAccounts(GameProfile gameProfile) {
        MinecraftServer server = ServerHelper.getServer();
        return CommonEconomy.getAccounts((MinecraftServer)server, (GameProfile)gameProfile);
    }

    @NotNull
    public static EconomyAccount getUserAccount(GameProfile gameProfile, class_2960 currencyId) {
        Optional<EconomyAccount> accountForThatCurrencyId = EconomyService.getUserAccounts(gameProfile).stream().filter(account -> {
            class_2960 id = account.currency().id();
            return id.equals((Object)currencyId);
        }).findFirst();
        if (accountForThatCurrencyId.isEmpty()) {
            throw new IllegalArgumentException("Player %s didn't have the account for currency ID %s.".formatted(gameProfile.getName(), currencyId));
        }
        return accountForThatCurrencyId.get();
    }

    public static CustomEconomyCurrencyNode getCustomCurrencyNode(class_2960 currencyId) {
        Optional<CustomEconomyCurrencyNode> currencyNoteOpt = EconomyInitializer.data.model().currencies.stream().filter(currency -> currency.currencyId.equals(currencyId.toString())).findFirst();
        if (currencyNoteOpt.isEmpty()) {
            if (EconomyService.isCurrencyInstalledOnThisServer(currencyId)) {
                CustomEconomyCurrencyNode customEconomyCurrencyNode = CustomEconomyCurrencyNode.make(currencyId.toString());
                EconomyInitializer.data.model().currencies.add(customEconomyCurrencyNode);
                EconomyInitializer.data.writeStorage();
                return customEconomyCurrencyNode;
            }
            throw new IllegalArgumentException("There is no currency ID %s in data file.".formatted(currencyId));
        }
        return currencyNoteOpt.get();
    }

    public static CustomEconomyAccountNode getCustomAccountNode(GameProfile gameProfile, class_2960 currencyId) {
        CustomEconomyCurrencyNode currencyNode = EconomyService.getCustomCurrencyNode(currencyId);
        Optional<CustomEconomyAccountNode> accountNodeOpt = currencyNode.accounts.stream().filter(it -> it.ownerName.equals(gameProfile.getName())).findFirst();
        if (accountNodeOpt.isEmpty()) {
            CustomEconomyCurrency customEconomyCurrency = CustomEconomyProvider.getCustomEconomyCurrency(currencyId);
            long defaultBalance = (long)(customEconomyCurrency.currencyDescriptor.defaultFaceBalance * 100.0);
            CustomEconomyAccountNode customEconomyAccountNode = CustomEconomyAccountNode.make(gameProfile, defaultBalance);
            currencyNode.accounts.add(customEconomyAccountNode);
            EconomyInitializer.data.writeStorage();
            return customEconomyAccountNode;
        }
        return accountNodeOpt.get();
    }

    public static void transferCurrency(class_3222 source, OfflineGameProfile player, class_2960 currencyId, double amount) {
        long deltaValue = (long)(amount * 100.0);
        deltaValue = Math.max(0L, deltaValue);
        EconomyAccount fromAccount = EconomyService.getUserAccount(source.method_7334(), currencyId);
        EconomyAccount toAccount = EconomyService.getUserAccount((GameProfile)player.getValue(), currencyId);
        long fromAccountPreviousBalance = fromAccount.balance();
        long toAccountPreviousBalance = toAccount.balance();
        if (fromAccount.canDecreaseBalance(deltaValue).isSuccessful() && toAccount.canIncreaseBalance(deltaValue).isSuccessful()) {
            try {
                fromAccount.decreaseBalance(deltaValue);
                toAccount.increaseBalance(deltaValue);
                TextHelper.sendTextByKey(source, "operation.success", new Object[0]);
            }
            catch (Exception rollbackIfFailed) {
                LogUtil.error("Failed to transfer currency {} with amount {} from account {} to account {}", currencyId, amount, fromAccount, toAccount, rollbackIfFailed);
                fromAccount.setBalance(fromAccountPreviousBalance);
                toAccount.setBalance(toAccountPreviousBalance);
                TextHelper.sendTextByKey(source, "operation.fail", new Object[0]);
            }
        } else {
            TextHelper.sendTextByKey(source, "operation.fail", new Object[0]);
        }
    }
}

