/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.economy.structure;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.economy.api.EconomyAccount;
import eu.pb4.common.economy.api.EconomyCurrency;
import eu.pb4.common.economy.api.EconomyProvider;
import eu.pb4.common.economy.api.EconomyTransaction;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.module.initializer.economy.EconomyInitializer;
import io.github.sakurawald.fuji.module.initializer.economy.config.structure.CustomEconomyAccountNode;
import io.github.sakurawald.fuji.module.initializer.economy.config.structure.CustomEconomyCurrencyDescriptor;
import io.github.sakurawald.fuji.module.initializer.economy.service.EconomyService;
import io.github.sakurawald.fuji.module.initializer.economy.structure.CustomEconomyProvider;
import io.github.sakurawald.fuji.module.initializer.economy.structure.CustomEconomyTransaction;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class CustomEconomyAccount
implements EconomyAccount {
    @NotNull
    private final GameProfile gameProfile;
    @NotNull
    private final CustomEconomyCurrencyDescriptor currencyDescriptor;

    public CustomEconomyAccount(@NotNull GameProfile gameProfile, @NotNull CustomEconomyCurrencyDescriptor currencyDescriptor) {
        this.gameProfile = gameProfile;
        this.currencyDescriptor = currencyDescriptor;
    }

    public class_2561 name() {
        return TextHelper.getTextByValue(this.gameProfile, this.currencyDescriptor.currencyName, new Object[0]);
    }

    public UUID owner() {
        if (this.gameProfile != null) {
            return this.gameProfile.getId();
        }
        return class_156.field_25140;
    }

    public class_2960 id() {
        return RegistryHelper.makeIdentifier(this.currencyDescriptor.currencyId);
    }

    public long balance() {
        CustomEconomyAccountNode accountNode = EconomyService.getCustomAccountNode(this.gameProfile, this.currencyDescriptor.toIdentifier());
        return accountNode.balance;
    }

    public void setBalance(long value) {
        CustomEconomyAccountNode accountNode = EconomyService.getCustomAccountNode(this.gameProfile, this.currencyDescriptor.toIdentifier());
        accountNode.balance = value;
        EconomyInitializer.data.writeStorage();
    }

    public EconomyTransaction canIncreaseBalance(long value) {
        return this.makeEconomyTransaction(value);
    }

    public EconomyTransaction canDecreaseBalance(long value) {
        return this.makeEconomyTransaction(-value);
    }

    private EconomyTransaction makeEconomyTransaction(long deltaValue) {
        class_2561 feedbackText;
        boolean isSuccessful;
        long previousBalance = this.balance();
        long transactionAmount = deltaValue;
        long finalBalance = previousBalance + transactionAmount;
        class_2960 currencyId = this.currencyDescriptor.toIdentifier();
        EconomyAccount economyAccount = EconomyService.getUserAccount(this.gameProfile, currencyId);
        if (finalBalance < 0L || transactionAmount > 0L && previousBalance > Long.MAX_VALUE - transactionAmount || transactionAmount < 0L && previousBalance < Long.MIN_VALUE - transactionAmount) {
            isSuccessful = false;
            finalBalance = previousBalance;
            feedbackText = TextHelper.getTextByKey(this.gameProfile, "operation.fail", new Object[0]);
        } else {
            isSuccessful = true;
            feedbackText = TextHelper.getTextByKey(this.gameProfile, "operation.success", new Object[0]);
        }
        return new CustomEconomyTransaction(economyAccount, isSuccessful, feedbackText, previousBalance, transactionAmount, finalBalance);
    }

    public EconomyProvider provider() {
        return CustomEconomyProvider.INSTANCE;
    }

    public EconomyCurrency currency() {
        return CustomEconomyProvider.getCustomEconomyCurrency(this.currencyDescriptor.toIdentifier());
    }
}

