/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.economy.structure;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.economy.api.CommonEconomy;
import eu.pb4.common.economy.api.EconomyAccount;
import eu.pb4.common.economy.api.EconomyCurrency;
import eu.pb4.common.economy.api.EconomyProvider;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.document.annotation.ForDeveloper;
import io.github.sakurawald.fuji.module.initializer.economy.EconomyInitializer;
import io.github.sakurawald.fuji.module.initializer.economy.config.structure.CustomEconomyCurrencyDescriptor;
import io.github.sakurawald.fuji.module.initializer.economy.structure.CustomEconomyAccount;
import io.github.sakurawald.fuji.module.initializer.economy.structure.CustomEconomyCurrency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

@ForDeveloper(value="Each mod should register its own economy provider, to provide new types of currencies.\nOne economy provider, can provide many many types of currencies.\nFor each player, one economy account, holds one economy currency type.\n\n")
public class CustomEconomyProvider
implements EconomyProvider {
    public static final String CUSTOM_ECONOMY_PROVIDER_NAMESPACE = "fuji";
    public static CustomEconomyProvider INSTANCE = new CustomEconomyProvider();
    public static final double SUPPORTED_PRECISE_FACTOR = 100.0;
    public static Map<class_2960, CustomEconomyCurrency> CURRENCY_ID_2_CURRENCY = new HashMap<class_2960, CustomEconomyCurrency>();

    public static void initializeCustomEconomyProvider() {
    }

    public static CustomEconomyCurrency getCustomEconomyCurrency(class_2960 currencyId) {
        return CURRENCY_ID_2_CURRENCY.get(currencyId);
    }

    public class_2561 name() {
        return class_2561.method_43470((String)"FUJI_ECONOMY_PROVIDER");
    }

    public class_1799 icon() {
        return class_1802.field_42688.method_7854();
    }

    private static void registerDefinedFujiCurrencies() {
        EconomyInitializer.config.model().currencies.forEach(descriptor -> {
            class_2960 currencyId = RegistryHelper.makeIdentifier(descriptor.currencyId);
            RegistryHelper.ensureIdentifierNamespaceIfFuji(currencyId);
            CustomEconomyCurrency customEconomyCurrency = new CustomEconomyCurrency((CustomEconomyCurrencyDescriptor)descriptor);
            LogUtil.debug("Register custom economy currency: currencyId = {}, currencyDescriptor = {}", currencyId, customEconomyCurrency);
            CURRENCY_ID_2_CURRENCY.put(currencyId, customEconomyCurrency);
        });
    }

    @Nullable
    public EconomyAccount getAccount(MinecraftServer server, GameProfile gameProfile, String pathOfCurrencyId) {
        Optional<EconomyAccount> first = this.getAccounts(server, gameProfile).stream().filter(account -> {
            String path = account.currency().id().method_12832();
            return path.equals(pathOfCurrencyId);
        }).findFirst();
        if (first.isEmpty()) {
            LogUtil.error("getAccount(): gameProfile = {}, pathOfCurrencyId = {}", gameProfile.getName(), pathOfCurrencyId);
            throw new IllegalArgumentException("Failed to get account for specified account ID.");
        }
        return first.get();
    }

    public Collection<EconomyAccount> getAccounts(MinecraftServer server, GameProfile gameProfile) {
        return EconomyInitializer.config.model().currencies.stream().map(economyCurrencyDescriptor -> new CustomEconomyAccount(gameProfile, (CustomEconomyCurrencyDescriptor)economyCurrencyDescriptor)).collect(Collectors.toList());
    }

    @Nullable
    public EconomyCurrency getCurrency(MinecraftServer server, String pathOfCurrencyId) {
        Optional<Map.Entry> currencyOpt = CURRENCY_ID_2_CURRENCY.entrySet().stream().filter(entry -> {
            String path = ((class_2960)entry.getKey()).method_12832();
            return path.equals(pathOfCurrencyId);
        }).findFirst();
        if (currencyOpt.isEmpty()) {
            throw new IllegalArgumentException("Failed to find custom currency in server: path of currency ID = " + pathOfCurrencyId);
        }
        return (EconomyCurrency)currencyOpt.get().getValue();
    }

    public Collection<EconomyCurrency> getCurrencies(MinecraftServer server) {
        return new ArrayList<EconomyCurrency>(CURRENCY_ID_2_CURRENCY.values());
    }

    @Nullable
    public String defaultAccount(MinecraftServer server, GameProfile gameProfile, EconomyCurrency currency) {
        return currency.id().method_12832();
    }

    static {
        CommonEconomy.register((String)CUSTOM_ECONOMY_PROVIDER_NAMESPACE, (EconomyProvider)INSTANCE);
        CustomEconomyProvider.registerDefinedFujiCurrencies();
    }
}

