/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.fuji.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.IOUtil;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.config.Configs;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.gui.impl.gui.PagedGui;
import io.github.sakurawald.fuji.module.initializer.fuji.gui.JavaObjectInspectionGui;
import io.github.sakurawald.fuji.module.initializer.fuji.structure.InspectingObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationsInspectionGui
extends PagedGui<BaseConfigurationHandler<?>> {
    public ConfigurationsInspectionGui(@Nullable SimpleGui parent, class_3222 player, @NotNull List<BaseConfigurationHandler<?>> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "fuji.inspect.configuration.gui.title", new Object[0]), entities, pageIndex);
    }

    public static ConfigurationsInspectionGui inspectAll(SimpleGui parent, class_3222 player) {
        List<BaseConfigurationHandler<?>> entities = BaseConfigurationHandler.REGISTERED_CONFIGURATION_HANDLERS.stream().filter(it -> it instanceof ObjectConfigurationHandler).sorted(Comparator.comparing(BaseConfigurationHandler::getPath)).toList();
        return new ConfigurationsInspectionGui(parent, player, entities, 0);
    }

    @Override
    protected PagedGui<BaseConfigurationHandler<?>> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<BaseConfigurationHandler<?>> entities, int pageIndex) {
        return new ConfigurationsInspectionGui(parent, player, entities, pageIndex);
    }

    @Override
    protected GuiElementInterface toGuiElement(BaseConfigurationHandler<?> entity) {
        String configModelClassName = ReflectionUtil.getSimpleClassName(entity.getClass());
        String configRelativePath = IOUtil.computeRelativePathBasedOnGameDir(entity.getPath().toFile());
        String fromModule = entity.getSourceModule();
        List<class_2561> lore = List.of(TextHelper.getTextByKey(this.getPlayer(), "from_module", fromModule), TextHelper.getTextByKey(this.getPlayer(), "fuji.inspect.configuration.class", configModelClassName), TextHelper.getTextByKey(this.getPlayer(), "fuji.inspect.configuration.path", configRelativePath), TextHelper.getTextByKey(this.getPlayer(), "prompt.click.see_inside", new Object[0]));
        SimpleGui trueParentGui = this.getParent() != null ? this.getParent() : this.getBackendGui();
        GuiElementBuilder guiElementBuilder = (GuiElementBuilder)new GuiElementBuilder().setItem(ConfigurationsInspectionGui.toItem(entity)).setName((class_2561)class_2561.method_43470((String)configRelativePath)).setLore(lore).setCallback(() -> this.inspectWithJavaObjectInspector(trueParentGui, entity, configRelativePath));
        return guiElementBuilder.build();
    }

    private void inspectWithJavaObjectInspector(SimpleGui parent, BaseConfigurationHandler<?> entity, String topLevelName) {
        new JavaObjectInspectionGui(parent, entity.model(), this.getPlayer(), new ArrayList<InspectingObject>(), 0, topLevelName, ".").open();
    }

    private static class_1792 toItem(BaseConfigurationHandler<?> entity) {
        if (entity == Configs.MAIN_CONTROL_CONFIG) {
            return class_1802.field_8466;
        }
        return class_1802.field_8247;
    }
}

