/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.fuji.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.impl.gui.PagedGui;
import io.github.sakurawald.fuji.module.initializer.fuji.structure.InspectingObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaObjectInspectionGui
extends PagedGui<InspectingObject> {
    private final String fileRelativePath;
    private final String walkingPath;

    public JavaObjectInspectionGui(@Nullable SimpleGui parent, @Nullable Object objectToInspect, class_3222 player, @NotNull List<InspectingObject> entities, int pageIndex, String fileRelativePath, @NotNull String walkingPath) {
        super(parent, player, TextHelper.getTextByKey(player, "object.gui.title", walkingPath), entities, pageIndex);
        this.fileRelativePath = fileRelativePath;
        this.walkingPath = walkingPath;
        if (objectToInspect != null) {
            this.getEntities().addAll(InspectingObject.inspectJavaObject(objectToInspect));
        }
        this.getFooter().setSlot(4, (GuiElementBuilderInterface)GuiHelper.makeHelpButton(player).setLore(List.of(TextHelper.getTextByKey(player, "object.top_level", fileRelativePath))));
    }

    @Override
    protected PagedGui<InspectingObject> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<InspectingObject> entities, int pageIndex) {
        return new JavaObjectInspectionGui(parent, null, player, entities, pageIndex, this.fileRelativePath, this.walkingPath);
    }

    @Override
    protected GuiElementInterface toGuiElement(InspectingObject entity) {
        GuiElementBuilder guiElementBuilder = (GuiElementBuilder)new GuiElementBuilder().setName(entity.computeNameText(this.getPlayer())).setItem(entity.computeItem()).setLore(entity.computeLore(this.getPlayer())).setCallback(() -> this.onClickToGoInside(this.getPlayer(), entity));
        return guiElementBuilder.build();
    }

    private void onClickToGoInside(class_3222 player, InspectingObject entity) {
        Object objectToInspect = entity.getObjectValue();
        if (objectToInspect == null) {
            return;
        }
        String objectName = entity.getObjectName();
        if (!entity.canGoInside()) {
            return;
        }
        List<Object> newEntities = new ArrayList();
        if (Iterable.class.isAssignableFrom(objectToInspect.getClass())) {
            newEntities = ((Collection)objectToInspect).stream().map(element -> new InspectingObject(element, null, "ELT")).toList();
            objectToInspect = null;
        } else if (Map.class.isAssignableFrom(objectToInspect.getClass())) {
            newEntities = ((Map)objectToInspect).entrySet().stream().map(entry -> {
                String jsonObjectKeyName = null;
                if (String.class.isAssignableFrom(entry.getKey().getClass())) {
                    jsonObjectKeyName = "\"" + String.valueOf(entry.getKey()) + "\"";
                }
                return new InspectingObject(entry, null, jsonObjectKeyName);
            }).toList();
            objectToInspect = null;
        } else if (Map.Entry.class.isAssignableFrom(objectToInspect.getClass())) {
            Map.Entry entry2 = (Map.Entry)objectToInspect;
            InspectingObject entryKeyObject = new InspectingObject(entry2.getKey(), null, "KEY");
            InspectingObject entryValueObject = new InspectingObject(entry2.getValue(), null, "VALUE");
            newEntities = List.of(entryKeyObject, entryValueObject);
            objectToInspect = null;
        }
        Object newWalkingPath = this.walkingPath + "." + objectName;
        newWalkingPath = CommandHelper.trimPathString((String)newWalkingPath);
        new JavaObjectInspectionGui(this.getBackendGui(), objectToInspect, this.getPlayer(), newEntities, 0, this.fileRelativePath, (String)newWalkingPath).open();
    }
}

