/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.fuji.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.auxiliary.DocumentUtil;
import io.github.sakurawald.fuji.core.gui.impl.gui.PagedGui;
import io.github.sakurawald.fuji.core.manager.impl.module.ModuleManager;
import io.github.sakurawald.fuji.core.structure.Pair;
import io.github.sakurawald.fuji.module.initializer.fuji.gui.ModuleDetailsInspectionGui;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesInspectionGui
extends PagedGui<Pair<String, Boolean>> {
    public ModulesInspectionGui(SimpleGui parent, class_3222 player, @NotNull List<Pair<String, Boolean>> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "fuji.inspect.modules.gui.title", new Object[0]), entities, pageIndex);
    }

    @Override
    protected PagedGui<Pair<String, Boolean>> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<Pair<String, Boolean>> entities, int pageIndex) {
        return new ModulesInspectionGui(parent, player, entities, pageIndex);
    }

    public static ModulesInspectionGui inspectAll(SimpleGui parent, class_3222 player) {
        List<Pair<String, Boolean>> entities = ModuleManager.MODULE_ENABLE_STATUS.entrySet().stream().map(it -> new Pair<String, Boolean>(ModuleManager.joinModulePath((List)it.getKey()), (Boolean)it.getValue())).sorted(Comparator.comparing(Pair::getKey)).collect(Collectors.toList());
        entities.add(0, new Pair<String, Boolean>("core", true));
        return new ModulesInspectionGui(parent, player, entities, 0);
    }

    @Override
    protected GuiElementInterface toGuiElement(Pair<String, Boolean> entity) {
        String classDocument;
        Class moduleInitializerClass;
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        boolean moduleEnableStatus = entity.getValue();
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "module.enable.status", moduleEnableStatus));
        String modulePathString = entity.getKey();
        List<ColorBox> colorBoxes = ModuleDetailsInspectionGui.getColorBoxes(modulePathString);
        if (moduleEnableStatus || !colorBoxes.isEmpty()) {
            lore.addAll(TextHelper.getTextListByKey(this.getPlayer(), "prompt.click.see_inside"));
        }
        if ((moduleInitializerClass = (Class)ModuleManager.MODULE_INITIALIZER_CLASS_BY_MODULE_PATH_STRING.getOrDefault(modulePathString, null)) != null && (classDocument = DocumentUtil.getClassDocumentString(this.getPlayer(), moduleInitializerClass)) != null) {
            lore.add(TextHelper.TEXT_EMPTY);
            lore.addAll(TextHelper.getDocumentTextList(this.getPlayer(), classDocument));
        }
        class_1792 itemMaterial = ModulesInspectionGui.getItemMaterial(entity);
        class_5250 itemName = class_2561.method_43470((String)modulePathString).method_27692(class_124.field_1054);
        return ((GuiElementBuilder)new GuiElementBuilder().setItem(itemMaterial).setName((class_2561)itemName).setLore(lore).setCallback(() -> this.openModuleDetailsInspectionGui(this.getBackendGui(), this.getPlayer(), modulePathString, moduleEnableStatus))).build();
    }

    private static class_1792 getItemMaterial(Pair<String, Boolean> entity) {
        String modulePathString = entity.getKey();
        if (modulePathString.equals("core")) {
            return class_1802.field_27019;
        }
        Boolean moduleEnableStatus = entity.getValue();
        return moduleEnableStatus != false ? class_1802.field_8734 : class_1802.field_8636;
    }

    private void openModuleDetailsInspectionGui(@Nullable SimpleGui parent, class_3222 player, String modulePathString, boolean moduleEnableStatus) {
        ModuleDetailsInspectionGui.inspectModuleDetails(parent, player, modulePathString, moduleEnableStatus).open();
    }
}

