/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.head.gui;

import com.mojang.authlib.GameProfile;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.AnvilInputGui;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.AsyncUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ItemStackHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.service.gameprofile_fetcher.MojangProfileFetcher;
import io.github.sakurawald.fuji.module.initializer.head.HeadInitializer;
import io.github.sakurawald.fuji.module.initializer.head.gui.HeadGui;
import io.github.sakurawald.fuji.module.initializer.head.structure.EconomyType;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class PlayerHeadGui
extends AnvilInputGui {
    @NotNull
    private final SimpleGui parentGui;
    private long apiDebounceTimeMs = 0L;

    public PlayerHeadGui(@NotNull HeadGui parentGui) {
        super(parentGui.player, false);
        this.parentGui = parentGui;
        this.setTitle(TextHelper.getTextByKey(this.player, "head.category.player", new Object[0]));
        this.setSlot(1, GuiHelper.makeBarrierButton());
        this.resetResultSlot();
    }

    public void setDefaultInputValue(String input) {
        this.setSlot(0, GuiHelper.makeBarrierButton());
        super.setDefaultInputValue("");
    }

    public void onInput(String input) {
        super.onInput(input);
        this.apiDebounceTimeMs = System.currentTimeMillis() + 500L;
    }

    public void onClose() {
        this.parentGui.open();
    }

    private void resetResultSlot() {
        this.setSlot(2, GuiHelper.makeBarrierButton());
    }

    public void onTick() {
        if (this.apiDebounceTimeMs != 0L && this.apiDebounceTimeMs <= System.currentTimeMillis()) {
            this.apiDebounceTimeMs = 0L;
            AsyncUtil.runAsyncAndSwallowExceptions(() -> {
                GameProfile gameProfile = MojangProfileFetcher.makeOnlineGameProfile(this.getInput());
                GuiElementBuilder builder = new GuiElementBuilder().setItem(class_1802.field_8575).setSkullOwner(gameProfile, EntityHelper.getMinecraftServer((class_1297)this.player));
                if (HeadInitializer.head.model().economy_type != EconomyType.FREE) {
                    builder.addLoreLine((class_2561)class_2561.method_43473());
                    builder.addLoreLine((class_2561)TextHelper.getTextByKey(this.player, "head.price", new Object[0]).method_27661().method_10852(EconomyType.getCostText()));
                }
                class_1799 headStack = builder.asStack();
                this.setSlot(2, headStack, (index, type, action, gui) -> EconomyType.tryPurchaseHeads(this.player, 1, () -> {
                    class_1799 cursorStack = this.getPlayer().field_7512.method_34255();
                    if (this.player.field_7512.method_34255().method_7960()) {
                        this.player.field_7512.method_34254(headStack.method_7972());
                    } else if (ItemStackHelper.canCombine(headStack, cursorStack) && cursorStack.method_7947() < cursorStack.method_7914()) {
                        cursorStack.method_7933(1);
                    } else {
                        this.player.method_7328(headStack.method_7972(), false);
                    }
                }));
            });
        }
    }
}

