/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.home;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.MetaDescriptor;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.home.command.argument.wrapper.HomeName;
import io.github.sakurawald.fuji.module.initializer.home.config.model.HomeDataModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Document(id=1751827004970L, value="Allows players to define their homes.\n")
public class HomeInitializer
extends ModuleInitializer {
    @DocStringProvider(id=1752000367398L, value="The home amount limit for this player.\n")
    private static final MetaDescriptor<Integer> MAX_HOME_AMOUNT_META = new MetaDescriptor<Integer>("fuji.home.home_limit", Integer::valueOf, 1752000367398L);
    private static final BaseConfigurationHandler<HomeDataModel> storage = new ObjectConfigurationHandler<HomeDataModel>("home.json", HomeDataModel.class).setAutoSaveEveryMinute();

    public static Map<String, GlobalPos> withHomes(@NotNull class_3222 player) {
        String playerName = player.method_7334().getName();
        Map<String, Map<String, GlobalPos>> homes = HomeInitializer.storage.model().name2home;
        homes.computeIfAbsent(playerName, k -> new HashMap());
        return homes.get(playerName);
    }

    @CommandNode(value="home tp")
    private static int $tp(@CommandSource class_3222 player, HomeName home) {
        Map<String, GlobalPos> homes = HomeInitializer.withHomes(player);
        String homeName = (String)home.getValue();
        HomeInitializer.ensureHomeExists(player, homes, homeName);
        GlobalPos globalPos = homes.get(homeName);
        globalPos.teleport(player);
        return 1;
    }

    private static void ensureHomeExists(class_3222 player, Map<String, GlobalPos> homes, String homeName) {
        if (!homes.containsKey(homeName)) {
            TextHelper.sendTextByKey(player, "home.not_found", homeName);
            throw new AbortCommandExecutionException();
        }
    }

    @CommandNode(value="home unset")
    private static int $unset(@CommandSource class_3222 player, HomeName home) {
        Map<String, GlobalPos> homes = HomeInitializer.withHomes(player);
        String homeName = (String)home.getValue();
        HomeInitializer.ensureHomeExists(player, homes, homeName);
        homes.remove(homeName);
        TextHelper.sendTextByKey(player, "home.unset.success", homeName);
        return 1;
    }

    @CommandNode(value="home set")
    private static int $set(@CommandSource class_3222 player, HomeName home, Optional<Boolean> override) {
        String homeName;
        Map<String, GlobalPos> name2position = HomeInitializer.withHomes(player);
        if (name2position.containsKey(homeName = (String)home.getValue()) && !override.orElse(false).booleanValue()) {
            TextHelper.sendTextByKey(player, "home.set.fail.need_override", homeName);
            return -1;
        }
        Optional<Integer> limit = LuckpermsHelper.getMeta(player.method_5667(), MAX_HOME_AMOUNT_META, new Object[0]);
        if (limit.isPresent() && name2position.size() >= limit.get()) {
            TextHelper.sendTextByKey(player, "home.set.fail.limit", new Object[0]);
            return -1;
        }
        name2position.put(homeName, GlobalPos.of(player));
        TextHelper.sendTextByKey(player, "home.set.success", homeName);
        return 1;
    }

    @CommandNode(value="home list")
    private static int $list(@CommandSource class_3222 player) {
        TextHelper.sendTextByKey(player, "home.list", HomeInitializer.withHomes(player).keySet());
        return 1;
    }

    public static BaseConfigurationHandler<HomeDataModel> getStorage() {
        return storage;
    }
}

