/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.kit;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.kit.command.argument.wrapper.KitName;
import io.github.sakurawald.fuji.module.initializer.kit.gui.KitEditorGui;
import io.github.sakurawald.fuji.module.initializer.kit.service.KitService;
import io.github.sakurawald.fuji.module.initializer.kit.structure.Kit;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1751824812720L, value="Make a set of `items` as a kit, and give the kit to players.\n")
@ColorBoxes(value={@ColorBox(id=1751977591928L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Create a kit.\nIssue: `/kit editor` to create a new kit.\n\n\u25c9 Give a kit to a player.\nIssue: `/kit give \\<player\\> \\<kit-name\\>` to give a kit to a player.\n<red>NOTE: This is a admin-level command.\nYou need to use `command_bundle` module to create a `user-level` command, for players to `claim a kit`.\n"), @ColorBox(id=1751977687678L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Create a user-level command, for players to `claim a kit`.\nThe `/kit give` command is a `admin-level` command, you should not allow players to use it directly.\nYou need to use `command_bundle` module to create a new `user-level` command, and wrap the `/kit give` command.\n"), @ColorBox(id=1751977756034L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Associate a cooldown to a kit.\nYou can use `command_cooldown` module, to create a `named cooldown` for the `kit claim command`.\n\nTo create a `named cooldown`\nIssue: `/command-cooldown create example-kit-cooldown 60000`\n\nTo test the cooldown, and give the kit if the cooldown is satisfied.\nIssue: `/command-cooldown test example-kit-cooldown \\<player\\> --onFailed \"send-message %player:name% wait a moment\" kit give %player:name% example-kit|send-message %player:name% kit received.`\n"), @ColorBox(id=1751977848415L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Claim a specific kit automatically for online players.\nYou can use `command_scheduler` module, to execute the `kit claim command` for online players automatically every minute.\n"), @ColorBox(id=1751977880532L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Give the new-bie player a kit.\nYou can use `command_event` module, to give a kit to the new-bie player.\n")})
@CommandNode(value="kit")
@CommandRequirement(level=4)
public class KitInitializer
extends ModuleInitializer {
    @Document(id=1751824817401L, value="Open the kit editor GUI.")
    @CommandNode(value="editor")
    private static int $editor(@CommandSource class_3222 player) {
        KitEditorGui.make(player).open();
        return 1;
    }

    @Document(id=1751824821391L, value="Give the kit to the player.")
    @CommandNode(value="give")
    private static int $give(@CommandSource class_2168 source, class_3222 player, KitName kit) {
        String kitName = (String)kit.getValue();
        if (!KitService.hasKit(kitName)) {
            TextHelper.sendTextByKey(source, "kit.kit.empty", new Object[0]);
            return -1;
        }
        Kit kitInstance = KitService.readKit(kitName);
        KitService.giveKit(player, kitInstance);
        return 1;
    }

    @Override
    protected void onInitialize() {
        KitService.createKitDirectory();
    }
}

