/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.multiplier;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.MetaDescriptor;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.Optional;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Document(id=1751978330624L, value="This module allows you to `multiply` some `numeric values` in vanilla Minecraft.\n\nNow supported `numeric types`:\n1. `damage`: The damage to a player.\n2. `experience`: The gained experience of a player.\n")
@ColorBox(id=1751978406823L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Double the damage from `zombie` to a player.\nIssue: `/lp group default meta set fuji.multiplier.damage.minecraft:zombie 2`\n\n\u25c9 Cancel the `fall damage` to a player.\nIssue: `/lp group default meta set fuji.multiplier.damage.minecraft:fall 0`\n\n\u25c9 Double `all` damages to a player.\nIssue: `/lp group default meta set fuji.multiplier.damage.all 2`\n\n\u25c9 Half `all` damages to a player.\nIssue: `/lp group default meta set fuji.multiplier.damage.all 0.5`\n\n\u25c9 Double all experience a player gained.\nIssue: `/lp group default meta set fuji.multiplier.experience.all 2`\n")
public class MultiplierInitializer
extends ModuleInitializer {
    @DocStringProvider(id=1752000356004L, value="Specify the `multiply factor` for a specified `type` for this player.\n")
    public static final MetaDescriptor<Float> MULTIPLIER_META = new MetaDescriptor<Float>("fuji.multiplier.<multiplier-type>.<id>", Float::valueOf, 1752000356004L);

    public static float transform(@NotNull class_3222 player, String type, String key, float f) {
        Optional<Float> meta = LuckpermsHelper.getMeta(player.method_5667(), MULTIPLIER_META, type, key);
        return meta.map(factor -> Float.valueOf(f * factor.floatValue())).orElse(Float.valueOf(f)).floatValue();
    }
}

