/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.predicate;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2293;
import net.minecraft.class_3222;

@Document(id=1751826497994L, value="Provides `predicate` commands, which suffix with `?`.\n")
@ColorBoxes(value={@ColorBox(id=1751978705157L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 How it works?\nA `predicate command` will returns `SUCCESS` if `true`, and `FAILED` if `false`.\nIt relies on the `return value of command` in vanilla Minecraft.\nSee https://minecraft.fandom.com/wiki/Commands/return\n\nActually, you can also use the `predicate command` with `command block`.\n"), @ColorBox(id=1751978789271L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Test a condition, and then run a command if success.\nIssue: `/run as player \\<player\\> chain has-perm? %player:name% 4 chain say value is true`\n")})
@CommandRequirement(level=4)
public class PredicateInitializer
extends ModuleInitializer {
    @CommandNode(value="has-perm?")
    private static int $hasPerm(@CommandSource class_2168 source, class_3222 player, GreedyString stringPermission) {
        boolean value = LuckpermsHelper.hasPermission(player.method_5667(), new PermissionDescriptor(true, (String)stringPermission.getValue(), 0L), new Object[0]);
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @Document(id=1751826502598L, value="Predicate to test if the player has the level-perm?")
    @CommandNode(value="has-level?")
    private static int $hasLevel(@CommandSource class_2168 source, class_3222 player, int levelPermission) {
        boolean value = player.method_5687(levelPermission);
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @Document(id=1751826504480L, value="Predicate if online players >= n.")
    @CommandNode(value="has-players?")
    private static int $hasPlayers(@CommandSource class_2168 source, Optional<Integer> n) {
        int $n = n.orElse(0);
        boolean value = ServerHelper.getOnlinePlayers().size() >= $n;
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="is-op?")
    private static int $isOp(@CommandSource class_2168 source, class_3222 player) {
        boolean value = ServerHelper.getPlayerManager().method_14569(player.method_7334());
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="is-holding?")
    private static int $isHolding(@CommandSource class_2168 source, class_3222 player, class_2293.class_2295 itemPredicate) {
        boolean value = player.method_24520((Predicate)itemPredicate);
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="has-exp?")
    private static int $hasExp(@CommandSource class_2168 source, class_3222 player, int exp) {
        boolean value = player.field_7495 >= exp;
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="has-exp-level?")
    private static int $hasExpLevel(@CommandSource class_2168 source, class_3222 player, int expLevel) {
        boolean value = player.field_7520 >= expLevel;
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="is-in-world?")
    private static int $isInWorld(@CommandSource class_2168 source, class_3222 player, Dimension dimension) {
        boolean value = EntityHelper.getServerWorld((class_1297)player).equals(dimension.getValue());
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="is-in-gamemode?")
    private static int $isInGameMode(@CommandSource class_2168 source, class_3222 player, class_1934 gameMode) {
        boolean value = player.field_13974.method_14257().equals((Object)gameMode);
        return CommandHelper.Return.returnBoolean(source, value);
    }
}

