/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.rtp;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.annotation.CommandTarget;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.service.random_teleport.RandomTeleporter;
import io.github.sakurawald.fuji.core.structure.TeleportSetup;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.rtp.config.model.RtpConfigModel;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826337744L, value="Provides random teleportation.\n")
@ColorBoxes(value={@ColorBox(id=1751978911201L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 The feature of this module\n1. Per-dimension configurable\n2. Ignore unsafe blocks. (e.g. fluid blocks, powered snow)\n"), @ColorBox(id=1751978954547L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 Improve the performance of rtp.\nIt's highly recommended to pre generate the world chunks using `chunky` mod.\nIf the `target chunk` is not generated, then we have to generate it while doing the random teleport.\nTo generate a chunk requires about 2 seconds to 10 seconds.\nWhich will slow down the process of `/rtp`.\nIf you pre generates the world chunks, then it will be fast.\n"), @ColorBox(id=1751979061910L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 Limit the usage of `/rtp` command\nYou can use `command_cooldown` module, to setup a `cooldown` for `/rtp` command.\nTo prevent abuse.\n")})
public class RtpInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<RtpConfigModel> config = new ObjectConfigurationHandler<RtpConfigModel>("config.json", RtpConfigModel.class);

    @NotNull
    private static TeleportSetup withTeleportSetup(@NotNull class_3222 player, @NotNull class_3218 world) {
        List<TeleportSetup> list = RtpInitializer.config.model().setup.dimension;
        String dimension = RegistryHelper.toString((class_1937)world);
        Optional<TeleportSetup> first = list.stream().filter(o -> o.getDimension().equals(dimension)).findFirst();
        if (first.isEmpty()) {
            TextHelper.sendTextByKey(player, "rtp.dimension.disallow", RegistryHelper.toString((class_1937)world));
            throw new AbortCommandExecutionException();
        }
        return first.get();
    }

    @Document(id=1751826340406L, value="Random rtp in specified dimension.")
    @CommandNode(value="rtp")
    private static int $rtp(@CommandSource @CommandTarget class_3222 player, Optional<Dimension> dimension) {
        class_3218 serverWorld = dimension.isPresent() ? (class_3218)dimension.get().getValue() : EntityHelper.getServerWorld((class_1297)player);
        TeleportSetup setup = RtpInitializer.withTeleportSetup(player, serverWorld);
        TextHelper.sendTextByKey(player, "rtp.tip", new Object[0]);
        RandomTeleporter.request(player, setup, position -> TextHelper.sendTextByKey(player, "rtp.success", new Object[0]));
        return 1;
    }
}

