/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.skin;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GameProfileCollection;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.Word;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.service.gameprofile_fetcher.MojangProfileFetcher;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.skin.config.model.SkinConfigModel;
import io.github.sakurawald.fuji.module.initializer.skin.provider.MineSkinSkinProvider;
import io.github.sakurawald.fuji.module.initializer.skin.structure.SkinRestorer;
import io.github.sakurawald.fuji.module.initializer.skin.structure.SkinVariant;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826807167L, value="Customize the skins of players.\n")
@ColorBox(id=1751979120689L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Set a skin from mojang\nIssue: `/skin set mojang dream`\n\n\u25c9 Set a skin from custom URL\nIssue: `/skin set web slim \"https://s.namemc.com/i/bd53d152d0cd91d0.png\"`\n\n\u25c9 Use the default skins defined by the server\nIssue: `/skin use-default-skins`\n\n\u25c9 Use the online skin of your player name.\nIssue: `/skin use-online-skin`\n")
@CommandNode(value="skin")
public class SkinInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<SkinConfigModel> config = new ObjectConfigurationHandler<SkinConfigModel>("config.json", SkinConfigModel.class);

    @Document(id=1751826809279L, value="Set skin to a random default skin.")
    @CommandNode(value="use-default-skins")
    private static int $useDefault(@CommandSource CommandContext<class_2168> ctx) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), () -> SkinRestorer.getSkinStorage().getDefaultSkin());
        return 1;
    }

    @Document(id=1751826811767L, value="Set skin to a random default skin.")
    @CommandNode(value="use-default-skins")
    @CommandRequirement(level=4)
    private static int $useDefaultOthers(@CommandSource CommandContext<class_2168> ctx, GameProfileCollection target) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), (Collection)target.getValue(), true, () -> SkinRestorer.getSkinStorage().getDefaultSkin());
        return 1;
    }

    @Document(id=1751826814466L, value="Set skin to an online skin of the same name.")
    @CommandNode(value="use-online-skin")
    private static int $useOnlineSkin(@CommandSource CommandContext<class_2168> ctx) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), () -> MojangProfileFetcher.fetchOnlineSkin(((class_2168)ctx.getSource()).method_9214()));
        return 1;
    }

    @CommandNode(value="set mojang")
    private static int $setMojang(@CommandSource CommandContext<class_2168> ctx, Word skinName) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), () -> MojangProfileFetcher.fetchOnlineSkin((String)skinName.getValue()));
        return 1;
    }

    @Document(id=1751826816766L, value="Set skin to an online skin of a specified name.")
    @CommandNode(value="set mojang")
    @CommandRequirement(level=4)
    private static int $setMojangTarget(@CommandSource CommandContext<class_2168> ctx, Word skinName, GameProfileCollection target) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), (Collection)target.getValue(), true, () -> MojangProfileFetcher.fetchOnlineSkin((String)skinName.getValue()));
        return 1;
    }

    @Document(id=1751826819277L, value="Set skin to a custom url in steve model.")
    @CommandNode(value="set web classic")
    private static int $setWebClassic(@CommandSource CommandContext<class_2168> ctx, String url) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), () -> MineSkinSkinProvider.fetchSkin(url, SkinVariant.CLASSIC));
        return 1;
    }

    @Document(id=1751826822477L, value="Set skin to a custom url in steve model.")
    @CommandNode(value="set web classic")
    @CommandRequirement(level=4)
    private static int $setWebClassicOthers(@CommandSource CommandContext<class_2168> ctx, String url, GameProfileCollection target) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), (Collection)target.getValue(), true, () -> MineSkinSkinProvider.fetchSkin(StringArgumentType.getString((CommandContext)ctx, (String)"url"), SkinVariant.CLASSIC));
        return 1;
    }

    @Document(id=1751826827369L, value="Set skin to a custom url in alex model.")
    @CommandNode(value="set web slim")
    private static int $setWebSlim(@CommandSource CommandContext<class_2168> ctx, String url) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), () -> MineSkinSkinProvider.fetchSkin(url, SkinVariant.SLIM));
        return 1;
    }

    @Document(id=1751826829102L, value="Set skin to a custom url in alex model.")
    @CommandNode(value="set web slim")
    @CommandRequirement(level=4)
    private static int $setWebSlimOthers(@CommandSource CommandContext<class_2168> ctx, String url, GameProfileCollection target) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), (Collection)target.getValue(), true, () -> MineSkinSkinProvider.fetchSkin(StringArgumentType.getString((CommandContext)ctx, (String)"url"), SkinVariant.SLIM));
        return 1;
    }

    private static int doSkin(@NotNull class_2168 src, @NotNull Collection<GameProfile> targets, boolean setByOperator, @NotNull Supplier<Property> skinSupplier) {
        SkinRestorer.setSkinAsync(src.method_9211(), targets, skinSupplier).thenAccept(pair -> {
            Collection players = (Collection)pair.left();
            Collection profiles = (Collection)pair.right();
            if (profiles.isEmpty()) {
                TextHelper.sendTextByKey(src, "skin.action.failed", new Object[0]);
                return;
            }
            if (setByOperator) {
                TextHelper.sendTextByKey(src, "skin.action.affected_profile", String.join((CharSequence)", ", profiles.stream().map(GameProfile::getName).toList()));
                if (!players.isEmpty()) {
                    TextHelper.sendTextByKey(src, "skin.action.affected_player", String.join((CharSequence)", ", players.stream().map(p -> p.method_7334().getName()).toList()));
                }
            } else {
                TextHelper.sendTextByKey(src, "skin.action.ok", new Object[0]);
            }
        });
        return targets.size();
    }

    private static int doSkin(@NotNull class_2168 src, @NotNull Supplier<Property> skinSupplier) {
        if (src.method_44023() == null) {
            return -1;
        }
        return SkinInitializer.doSkin(src, Collections.singleton(src.method_44023().method_7334()), false, skinSupplier);
    }
}

