/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.skin.provider;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.properties.Property;
import io.github.sakurawald.fuji.core.auxiliary.IOUtil;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.module.initializer.skin.structure.SkinVariant;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MineSkinSkinProvider {
    private static final String API_ENDPOINT = "https://api.mineskin.org/generate/url";

    @Nullable
    public static Property fetchSkin(String url, @NotNull SkinVariant variant) {
        try {
            String param = "{\"variant\":\"%s\",\"name\":\"%s\",\"visibility\":%d,\"url\":\"%s\"}".formatted(variant.toString(), "none", 0, url);
            String json = IOUtil.requestPost(API_ENDPOINT, param);
            JsonObject texture = JsonParser.parseString((String)json).getAsJsonObject().getAsJsonObject("data").getAsJsonObject("texture");
            return new Property("textures", texture.get("value").getAsString(), texture.get("signature").getAsString());
        }
        catch (IOException e) {
            LogUtil.debug("Failed to fetch skin from mine-skin server: url = {}", url);
            return null;
        }
    }
}

