/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.system_message;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.system_message.config.model.SystemMessageConfigModel;
import java.util.Map;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;

@Document(id=1751824913807L, value="Customize the `translatable text`, like most of `system messages`.\n\nFor example, you can customize the `translatable texts` like:\n1. Player joined and left message.\n2. Player death message. (Like get killed by a zombie)\n3. Player whitelist message. (Used in the GUI)\n4. Player advancement message.\n5. Player command feedback. (The command feedback for a specified command)\n6. Server close message.\n7. ... (There are many translatable texts in server-side)\n")
@ColorBoxes(value={@ColorBox(id=1751979387990L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 What is a `translatable text`.\nIn client-side, you can change the `language option`, and see different `translatable texts`.\nThere are `language files for different languages` in your client.\nThings are similar in server-side.\nThere are `language files for different languages` in the `server side`.\n\nYou can see the example `language file` in https://github.com/sakurawald/fuji/blob/dev/.github/files/en_us.json\n\n\u25c9 How this module works?\nWhen the `server` tries to sends a `translatable text` to the `client` side.\nWe will see what `translatable text` is going to be sent, and `replace` it with `user-defined text` if needed.\nThe client just receive the `user-define text`, and display it to the player.\n"), @ColorBox(id=1751979760808L, color=ColorBox.ColorBlockTypes.WARNING, value="\u25c9 Don't customize the `translatable text` that is already handled by other mods\nFor example, if you are using `Styled Chat` mod, then you should not modify the `player join message` and `player leave message`.\nBecause the `Styled Chat` mod already handles them.\n"), @ColorBox(id=1751979931584L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Customize the player join message\nKey: `multiplayer.player.joined`\nValue: `\\<rainbow\\>+ %s`\n\n\u25c9 Customize the player leave mssage\nKey: `multiplayer.player.left`\nValue: `\\<dark_gray\\>%s leeeeeeeeft the game`\n"), @ColorBox(id=1751979996501L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Customize a specific death type message\nKey: `death.attack.explosion.player`\nValue: `\\<rainbow\\>%1$s booooooom because of %2$s`\n\n\u25c9 Customize a specific vanilla command feedback message\nKey: `commands.seed.success`\nValue: `\\<rainbow\\> Seeeeeeeeeeed: %s`\n"), @ColorBox(id=1751980039595L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Customize the text used in screen.\nKey: `multiplayer.disconnect.server_shutdown`\nValue: `Server closeeeeeeeed`\n\nKey: `multiplayer.disconnect.not_whitelisted`\nValue: `\\<rainbow\\>Please apply a whitelist first!`\n\nKey: `container.chest`\nValue: `\\<rb\\>I see you opening the chest!`\n"), @ColorBox(id=1751980149228L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Cancel the sending of a specific message.\nKey: `multiplayer.player.left`\nValue: `null`\n\n<red>NOTE: If you leave the `value` to `null`, then it means let's `cancel` the sending of this translatable text.\n")})
public class SystemMessageInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<SystemMessageConfigModel> config = new ObjectConfigurationHandler<SystemMessageConfigModel>("config.json", SystemMessageConfigModel.class);

    @Nullable
    public static class_5250 modifyTranslatableText(String translatableKey, Object ... args) {
        Map<String, String> key2value = SystemMessageInitializer.config.model().key2value;
        if (key2value.containsKey(translatableKey)) {
            if (ServerHelper.getServer() == null) {
                LogUtil.warn("Server is null currently, cannot hijack the translatable text with the key: {}", translatableKey);
                return null;
            }
            String value = key2value.get(translatableKey);
            if (value == null) {
                return null;
            }
            class_2588 forceFallbackToSpecifiedValue = new class_2588("force_fallback", value, args);
            String resolveArgumentsAsString = class_5250.method_43477((class_7417)forceFallbackToSpecifiedValue).getString();
            class_5250 newText = TextHelper.getTextByValue(null, resolveArgumentsAsString, new Object[0]).method_27661();
            LogUtil.debug("Replace the translatable text {} with new value.", translatableKey);
            return newText;
        }
        return null;
    }
}

