/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.teleport_warmup;

import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.MetaDescriptor;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.core.manager.impl.bossbar.BossBarTicket;
import io.github.sakurawald.fuji.core.structure.TeleportTicket;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.teleport_warmup.config.model.TeleportWarmupConfigModel;
import java.util.Optional;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Document(id=1751826791752L, value="Adds a warmup cooldown before player teleportation.\n")
@ColorBox(id=1751980526151L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 How it works?\nInside the vanilla Minecraft, there is a teleport function for teleportation.\nWe listen on this teleport function, and wrap it with a warmup cooldown.\n\n\u25c9 How can I specify different cooldown time for different commands?\nYou need to use `command_warmup` module.\nThe `command_cooldown` module will simply treats `all` the teleportation request the same.\nThat's because we only know there is a teleport request.\nBut we didn't even know who creates this teleport request.\nSo we have to treat `all` teleportation the same.\n\n\u25c9 What's the point of teleport warmup.\nThe main purpose is to prevent the `abuse` of `teleport commands` in vanilla Minecraft.\nLike, use teleport commands to escape death.\n")
public class TeleportWarmupInitializer
extends ModuleInitializer {
    @DocStringProvider(id=1752000321033L, value="To bypass all teleport warmup.\n")
    public static final PermissionDescriptor TELEPORT_WARMUP_BYPASS_PERMISSION = new PermissionDescriptor("fuji.teleport_warmup.bypass", 1752000321033L);
    @DocStringProvider(id=1752000334206L, value="Specify the teleport warmup time in seconds for this player.\n")
    public static final MetaDescriptor<Integer> TELEPORT_WARMUP_TIME_META = new MetaDescriptor<Integer>("fuji.teleport_warmup.warmup", Integer::valueOf, 1752000334206L);
    public static final BaseConfigurationHandler<TeleportWarmupConfigModel> config = new ObjectConfigurationHandler<TeleportWarmupConfigModel>("config.json", TeleportWarmupConfigModel.class);

    @Nullable
    public static TeleportTicket getTeleportTicket(@NotNull class_3222 player) {
        Optional<BossBarTicket> optValue = Managers.getBossBarManager().getTickets().stream().filter(it -> {
            TeleportTicket teleportTicket;
            return it instanceof TeleportTicket && (teleportTicket = (TeleportTicket)it).getPlayer().equals((Object)player);
        }).findFirst();
        return optValue.orElse(null);
    }
}

