/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.top_chunks;

import io.github.sakurawald.fuji.core.auxiliary.AsyncUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.top_chunks.config.model.TopChunksConfigModel;
import io.github.sakurawald.fuji.module.initializer.top_chunks.gui.TopChunksGui;
import io.github.sakurawald.fuji.module.initializer.top_chunks.structure.ChunkScore;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826535209L, value="Analyze all loaded chunks of the server, and find the most lagged chunks.\n")
@ColorBox(id=1751981000562L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 How it works?\nThis module use a `simple statistical method` to estimate the `degree of lag of a chunk`.\nThe method is simple, it simply counts the `entities` and `block entities` inside a `chunk`.\nAnd sum up the `score` by the `type` of `entity` or `block entity`.\n\nIt's simple, fast and useful.\nYou can define the score of `a zombie` as `4`.\nThe score of `a bee` as `15`.\nAnd the score of `a piston` as `10`.\nThat depends on your case.\nSimple method often works.\n")
public class TopChunksInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<TopChunksConfigModel> config = new ObjectConfigurationHandler<TopChunksConfigModel>("config.json", TopChunksConfigModel.class);

    @Document(id=1751826537195L, value="List all chunks ordered by lag score.")
    @CommandNode(value="chunks")
    private static int $chunks(@CommandSource class_2168 source) {
        AsyncUtil.runAsyncAndHandleExceptions(() -> {
            PriorityQueue<ChunkScore> PQ = new PriorityQueue<ChunkScore>();
            for (class_3218 world : ServerHelper.getWorlds()) {
                HashMap<class_1923, ChunkScore> topChunkReport = new HashMap<class_1923, ChunkScore>();
                for (class_1297 entity : world.method_27909()) {
                    class_1923 pos = entity.method_31476();
                    topChunkReport.putIfAbsent(pos, new ChunkScore(world, pos));
                    ((ChunkScore)topChunkReport.get(pos)).plusEntity(entity);
                }
                for (class_3193 chunkHolder : ServerHelper.getChunks(world)) {
                    class_2818 worldChunk = chunkHolder.method_16144();
                    if (worldChunk == null) continue;
                    for (class_2586 blockEntity : worldChunk.method_12214().values()) {
                        class_1923 pos = worldChunk.method_12004();
                        topChunkReport.putIfAbsent(pos, new ChunkScore(world, pos));
                        ((ChunkScore)topChunkReport.get(pos)).plusBlockEntity(blockEntity);
                    }
                }
                topChunkReport.values().forEach(chunkScore -> {
                    chunkScore.sum();
                    PQ.add((ChunkScore)chunkScore);
                });
            }
            TopChunksInitializer.attachNearestPlayerIntoChunkScore(source, PQ, TopChunksInitializer.getMaxDisplayChunkScore());
            TopChunksInitializer.sendTopChunksReport(source, PQ);
        });
        return 1;
    }

    private static void sendTopChunksReport(class_2168 source, PriorityQueue<ChunkScore> PQ) {
        if (source.method_43737()) {
            TopChunksInitializer.sendTopChunksReportAsGui(source, PQ);
        } else {
            TopChunksInitializer.sendTopChunksReportAsMessage(source, PQ);
        }
    }

    private static void sendTopChunksReportAsGui(class_2168 source, PriorityQueue<ChunkScore> PQ) {
        new TopChunksGui(source.method_44023(), PQ.stream().toList(), 0).open();
    }

    private static void sendTopChunksReportAsMessage(class_2168 source, PriorityQueue<ChunkScore> PQ) {
        TopChunksConfigModel config = TopChunksInitializer.config.model();
        class_5250 reportText = class_2561.method_43473();
        block0: for (int j = 0; j < config.top.rows; ++j) {
            for (int i = 0; i < config.top.columns; ++i) {
                if (PQ.isEmpty()) break block0;
                reportText.method_10852(PQ.poll().asText(source)).method_10852(TextHelper.TEXT_SPACE);
            }
            reportText.method_10852(TextHelper.TEXT_NEWLINE);
        }
        source.method_45068((class_2561)reportText);
    }

    private static void attachNearestPlayerIntoChunkScore(class_2168 source, @NotNull PriorityQueue<ChunkScore> PQ, int topN) {
        int count = 0;
        for (ChunkScore chunkScore : PQ) {
            class_1923 chunkPos;
            class_2338 blockPos;
            if (count++ >= topN) break;
            class_3218 world = chunkScore.getDimension();
            class_1657 nearestPlayer = world.method_18459((double)(blockPos = (chunkPos = chunkScore.getChunkPos()).method_8323()).method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (double)TopChunksInitializer.config.model().nearest_distance, false);
            if (nearestPlayer == null) continue;
            String nearestPlayerName = PlayerHelper.getPlayerName(nearestPlayer);
            String nearestPlayerString = TextHelper.Operators.visitString(TextHelper.getTextByKey(source, "top_chunks.prop.players.nearest", nearestPlayerName));
            chunkScore.getPlayers().add(nearestPlayerString);
        }
    }

    public static List<ChunkScore> trimChunkScoreList(List<ChunkScore> chunkScores) {
        int begin = 0;
        int end = Math.min(chunkScores.size(), TopChunksInitializer.getMaxDisplayChunkScore());
        return chunkScores.subList(begin, end);
    }

    public static int getMaxDisplayChunkScore() {
        TopChunksConfigModel.Top top = TopChunksInitializer.config.model().top;
        return top.rows * top.columns;
    }
}

