/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.tpa;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.job.impl.PlaySoundJob;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.tpa.config.model.TpaConfigModel;
import io.github.sakurawald.fuji.module.initializer.tpa.structure.TpaRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

@Document(id=1751826540953L, value="This module provides `/tpa` and `/tpahere` commands.")
public class TpaInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<TpaConfigModel> config = new ObjectConfigurationHandler<TpaConfigModel>("config.json", TpaConfigModel.class);
    private static final List<TpaRequest> requests = new ArrayList<TpaRequest>();

    @CommandNode(value="tpa")
    private static int $tpa(@CommandSource class_3222 player, class_3222 target) {
        return TpaInitializer.doRequest(player, target, false);
    }

    @CommandNode(value="tpahere")
    private static int $tpahere(@CommandSource class_3222 player, class_3222 target) {
        return TpaInitializer.doRequest(player, target, true);
    }

    @CommandNode(value="tpaaccept")
    private static int $tpaaccept(@CommandSource class_3222 player, class_3222 target) {
        return TpaInitializer.doResponse(player, target, ResponseStatus.ACCEPT);
    }

    private static int doResponseToAll(class_3222 me, ResponseStatus responseStatus) {
        ArrayList targetPlayers = requests.stream().filter(request -> {
            if (responseStatus == ResponseStatus.CANCEL) {
                return request.getSender().equals((Object)me);
            }
            return request.getReceiver().equals((Object)me);
        }).collect(Collectors.toCollection(ArrayList::new));
        targetPlayers.forEach(request -> {
            class_3222 responseTarget = responseStatus == ResponseStatus.CANCEL ? request.getReceiver() : request.getSender();
            TpaInitializer.doResponse(me, responseTarget, responseStatus);
        });
        return 1;
    }

    @CommandNode(value="tpaaccept all")
    private static int $tpaaccept(@CommandSource class_3222 player) {
        return TpaInitializer.doResponseToAll(player, ResponseStatus.ACCEPT);
    }

    @CommandNode(value="tpadeny")
    private static int $tpadeny(@CommandSource class_3222 player, class_3222 target) {
        return TpaInitializer.doResponse(player, target, ResponseStatus.DENY);
    }

    @CommandNode(value="tpadeny all")
    private static int $tpadeny(@CommandSource class_3222 player) {
        return TpaInitializer.doResponseToAll(player, ResponseStatus.DENY);
    }

    @CommandNode(value="tpacancel")
    private static int $tpacancel(@CommandSource class_3222 player, class_3222 target) {
        return TpaInitializer.doResponse(player, target, ResponseStatus.CANCEL);
    }

    @CommandNode(value="tpacancel all")
    private static int $tpacancel(@CommandSource class_3222 player) {
        return TpaInitializer.doResponseToAll(player, ResponseStatus.CANCEL);
    }

    private static int doResponse(class_3222 player, class_3222 target, ResponseStatus status) {
        Optional<TpaRequest> requestOpt = requests.stream().filter(request -> status == ResponseStatus.CANCEL ? request.getSender().equals((Object)player) && request.getReceiver().equals((Object)target) : request.getSender().equals((Object)target) && request.getReceiver().equals((Object)player)).findFirst();
        if (requestOpt.isEmpty()) {
            TextHelper.sendTextByKey(player, "tpa.no_relative_ticket", new Object[0]);
            return -1;
        }
        TpaRequest request2 = requestOpt.get();
        if (status == ResponseStatus.ACCEPT) {
            class_3222 who = request2.getTeleportWho();
            class_3222 to = request2.getTeleportTo();
            PlaySoundJob.scheduleJob(TpaInitializer.config.model().mention_player, request2.isTpahere() ? to : who);
            new GlobalPos(to.method_37908(), to.method_23317(), to.method_23318(), to.method_23321(), to.method_36454(), to.method_36455()).teleport(who);
            request2.getSender().method_7353((class_2561)request2.toSenderText$Accepted(), true);
            request2.getReceiver().method_43496((class_2561)request2.toReceiverText$Accepted());
        } else if (status == ResponseStatus.DENY) {
            request2.getSender().method_7353((class_2561)request2.toSenderText$Denied(), true);
            request2.getReceiver().method_43496((class_2561)request2.toReceiverText$Denied());
        } else if (status == ResponseStatus.CANCEL) {
            request2.getSender().method_43496((class_2561)request2.toSenderText$Cancelled());
            request2.getReceiver().method_43496((class_2561)request2.toReceiverText$Cancelled());
        }
        request2.cancelTimeout();
        requests.remove(request2);
        return 1;
    }

    private static int doRequest(class_3222 source, class_3222 target, boolean tpahere) {
        TpaRequest request = new TpaRequest(source, target, tpahere);
        if (request.getSender().equals((Object)request.getReceiver())) {
            TextHelper.sendTextByKey(request.getSender(), "tpa.request_to_self", new Object[0]);
            return -1;
        }
        if (requests.stream().anyMatch(request::isSimilarTo)) {
            TextHelper.sendTextByKey(request.getSender(), "tpa.similar_request_exists", new Object[0]);
            return -1;
        }
        requests.add(request);
        request.startTimeout();
        PlaySoundJob.scheduleJob(TpaInitializer.config.model().mention_player, request.getReceiver());
        request.getReceiver().method_43496((class_2561)request.toReceiverText$Sent());
        request.getSender().method_43496((class_2561)request.toSenderText$Sent());
        return 1;
    }

    public static List<TpaRequest> getRequests() {
        return requests;
    }

    private static enum ResponseStatus {
        ACCEPT,
        DENY,
        CANCEL;

    }
}

