/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.warning.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.impl.gui.ConfirmSignGui;
import io.github.sakurawald.fuji.core.gui.impl.gui.CrudPagedGui;
import io.github.sakurawald.fuji.core.gui.impl.gui.EditSignGui;
import io.github.sakurawald.fuji.core.gui.impl.gui.InputSignGui;
import io.github.sakurawald.fuji.core.gui.impl.gui.PagedGui;
import io.github.sakurawald.fuji.module.initializer.warning.WarningInitializer;
import io.github.sakurawald.fuji.module.initializer.warning.service.WarningService;
import io.github.sakurawald.fuji.module.initializer.warning.structure.PlayerWarnings;
import io.github.sakurawald.fuji.module.initializer.warning.structure.Warning;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListPlayerWarningsGui
extends CrudPagedGui<Warning> {
    private final String targetPlayerName;

    public ListPlayerWarningsGui(@Nullable SimpleGui parent, @NotNull class_3222 player, String targetPlayerName, @NotNull List<Warning> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "warning.list.gui.title", targetPlayerName), entities, pageIndex);
        this.targetPlayerName = targetPlayerName;
    }

    @Override
    protected PagedGui<Warning> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<Warning> entities, int pageIndex) {
        return new ListPlayerWarningsGui(parent, player, this.targetPlayerName, entities, pageIndex);
    }

    public static ListPlayerWarningsGui make(@Nullable SimpleGui parent, @NotNull class_3222 player, @NotNull String targetPlayerName) {
        PlayerWarnings playerWarnings = WarningService.getPlayerWarnings(targetPlayerName);
        return new ListPlayerWarningsGui(parent, player, targetPlayerName, playerWarnings.warnings, 0);
    }

    @Override
    protected GuiElementBuilder toGuiElementBuilder(Warning entity) {
        GuiElementBuilder builder = new GuiElementBuilder();
        builder.setItem(class_1802.field_8407).setName(TextHelper.getTextByKey(this.getPlayer(), "warning.list.gui.name", new Object[0])).setLore(entity.asLore(this.getPlayer()));
        return builder;
    }

    @Override
    @NotNull
    protected String getGuiHelpLoreKey() {
        return "warning.list.gui.help.lore";
    }

    @Override
    protected void onCreateEntity() {
        new InputSignGui(this.getPlayer(), null){

            public void onClose() {
                String warningDescription = this.joinStrings();
                if (warningDescription.isBlank()) {
                    ListPlayerWarningsGui.make(ListPlayerWarningsGui.this.getParent(), this.player, ListPlayerWarningsGui.this.targetPlayerName).open();
                    return;
                }
                String creatorName = PlayerHelper.getPlayerName((class_1657)this.player);
                WarningService.createWarning(creatorName, ListPlayerWarningsGui.this.targetPlayerName, warningDescription);
                ListPlayerWarningsGui.make(ListPlayerWarningsGui.this.getParent(), this.player, ListPlayerWarningsGui.this.targetPlayerName).open();
            }
        }.open();
    }

    @Override
    protected boolean canCreateEntity() {
        return LuckpermsHelper.hasPermission(this.getPlayer().method_5667(), WarningInitializer.CREATE_WARNINGS_PERMISSION, new Object[0]);
    }

    @Override
    protected boolean canReadEntity(Warning entity) {
        return LuckpermsHelper.hasPermission(this.getPlayer().method_5667(), WarningInitializer.READ_WARNINGS_PERMISSION, new Object[0]);
    }

    @Override
    protected boolean canUpdateEntity(Warning entity) {
        return LuckpermsHelper.hasPermission(this.getPlayer().method_5667(), WarningInitializer.UPDATE_WARNINGS_PERMISSION, new Object[0]);
    }

    @Override
    protected boolean canDeleteEntity(Warning entity) {
        return LuckpermsHelper.hasPermission(this.getPlayer().method_5667(), WarningInitializer.DELETE_WARNINGS_PERMISSION, new Object[0]);
    }

    @Override
    protected void onLeftClickEntity(final Warning entity) {
        if (!this.canUpdateEntity(entity)) {
            return;
        }
        String originalDescription = entity.description;
        new EditSignGui(this.getPlayer(), originalDescription){

            public void onClose() {
                String newDescription = this.joinStrings();
                entity.setDescription(newDescription);
                WarningInitializer.data.writeStorage();
                ListPlayerWarningsGui.make(ListPlayerWarningsGui.this.getParent(), this.player, ListPlayerWarningsGui.this.targetPlayerName).open();
            }
        }.open();
    }

    @Override
    protected void onRightClickEntity(final Warning entity) {
        if (!this.canDeleteEntity(entity)) {
            return;
        }
        new ConfirmSignGui(this.getPlayer()){

            @Override
            public void onConfirm() {
                WarningService.deleteWarning(ListPlayerWarningsGui.this.targetPlayerName, entity);
                ListPlayerWarningsGui.make(ListPlayerWarningsGui.this.getParent(), this.getPlayer(), ListPlayerWarningsGui.this.targetPlayerName).open();
            }
        }.open();
    }
}

