/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.warning.service;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.module.initializer.warning.WarningInitializer;
import io.github.sakurawald.fuji.module.initializer.warning.structure.PlayerWarnings;
import io.github.sakurawald.fuji.module.initializer.warning.structure.Warning;
import io.github.sakurawald.fuji.module.initializer.warning.structure.WarningRule;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class WarningService {
    public static void createWarning(String creatorName, String targetPlayerName, String warningDescription) {
        Warning newWarning = Warning.makeWarning(creatorName, warningDescription);
        WarningService.getPlayerWarnings((String)targetPlayerName).warnings.add(newWarning);
        WarningInitializer.data.writeStorage();
        WarningService.processWarningRules(targetPlayerName);
    }

    public static void deleteWarning(String targetPlayerName, Warning warning) {
        WarningService.getPlayerWarnings((String)targetPlayerName).warnings.remove(warning);
        WarningInitializer.data.writeStorage();
    }

    public static int clearWarnings(String targetPlayerName) {
        List<Warning> warnings = WarningService.getPlayerWarnings((String)targetPlayerName).warnings;
        int originalSize = warnings.size();
        warnings.clear();
        WarningInitializer.data.writeStorage();
        return originalSize;
    }

    public static void clearAllWarnings() {
        WarningInitializer.data.model().players = new ArrayList<PlayerWarnings>();
        WarningInitializer.data.writeStorage();
    }

    public static PlayerWarnings getPlayerWarnings(String playerName) {
        List<PlayerWarnings> players = WarningInitializer.data.model().players;
        Optional<PlayerWarnings> playerWarningsOpt = players.stream().filter(it -> it.player.equals(playerName)).findFirst();
        if (playerWarningsOpt.isPresent()) {
            return playerWarningsOpt.get();
        }
        PlayerWarnings playerWarnings = new PlayerWarnings(playerName);
        players.add(playerWarnings);
        WarningInitializer.data.writeStorage();
        return playerWarnings;
    }

    public static void processNotify(class_3222 targetPlayer, boolean isJoin) {
        String playerName = PlayerHelper.getPlayerName((class_1657)targetPlayer);
        PlayerWarnings playerWarnings = WarningService.getPlayerWarnings(playerName);
        if (playerWarnings.warnings.isEmpty()) {
            return;
        }
        ServerHelper.getOnlinePlayers().stream().filter(it -> LuckpermsHelper.hasPermission(it.method_5667(), WarningInitializer.NOTIFY_WARNINGS_PERMISSION, new Object[0])).forEach(it -> {
            int warningsSize = playerWarnings.warnings.size();
            if (isJoin) {
                TextHelper.sendTextByKey(it, "warning.notify.join", playerName, warningsSize);
            } else {
                TextHelper.sendTextByKey(it, "warning.notify.leave", playerName, warningsSize);
            }
        });
    }

    public static void processWarningRules(String targetPlayerName) {
        Optional<WarningRule> first = WarningInitializer.config.model().rules.stream().sorted(Comparator.comparing(WarningRule::getIfNumberOfWarningsGreaterEqualThan).reversed()).filter(it -> {
            int numberOfWarnings = WarningService.getPlayerWarnings((String)targetPlayerName).warnings.size();
            return numberOfWarnings >= it.getIfNumberOfWarningsGreaterEqualThan();
        }).findFirst();
        if (first.isPresent()) {
            WarningRule warningRule = first.get();
            LogUtil.info("Execute the warning rule for player {}: warning rule = {}", targetPlayerName, warningRule);
            class_2168 offlineServerCommandSource = PlayerHelper.loadOfflinePlayer(targetPlayerName).method_5671();
            ExtendedCommandSource extendedCommandSource = ExtendedCommandSource.asConsole(offlineServerCommandSource);
            List<String> commands = warningRule.commands;
            CommandExecutor.execute(extendedCommandSource, commands);
        }
    }
}

