/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.warning.structure;

import com.google.gson.annotations.SerializedName;
import io.github.sakurawald.fuji.core.auxiliary.ChronosUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import java.util.List;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class Warning {
    public long createdTimestamp;
    @SerializedName(value="creatorName", alternate={"createdByPlayer"})
    public String creatorName;
    public String description;

    public static Warning makeWarning(String creatorName, String description) {
        Warning warning = new Warning();
        warning.createdTimestamp = System.currentTimeMillis();
        warning.creatorName = creatorName;
        warning.description = description;
        return warning;
    }

    @NotNull
    public List<class_2561> asLore(Object audience) {
        return List.of(TextHelper.getTextByKey(audience, "entity.created_by_player", this.creatorName), TextHelper.getTextByKey(audience, "entity.created_timestamp", ChronosUtil.toDefaultDateFormat(this.createdTimestamp)), TextHelper.getTextByKey(audience, "entity.description", this.description));
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setCreatedTimestamp(long createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Warning)) {
            return false;
        }
        Warning other = (Warning)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreatedTimestamp() != other.getCreatedTimestamp()) {
            return false;
        }
        String this$creatorName = this.getCreatorName();
        String other$creatorName = other.getCreatorName();
        if (this$creatorName == null ? other$creatorName != null : !this$creatorName.equals(other$creatorName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Warning;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTimestamp = this.getCreatedTimestamp();
        result = result * 59 + (int)($createdTimestamp >>> 32 ^ $createdTimestamp);
        String $creatorName = this.getCreatorName();
        result = result * 59 + ($creatorName == null ? 43 : $creatorName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "Warning(createdTimestamp=" + this.getCreatedTimestamp() + ", creatorName=" + this.getCreatorName() + ", description=" + this.getDescription() + ")";
    }
}

