/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.works.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.impl.gui.PagedGui;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.module.initializer.works.WorksInitializer;
import io.github.sakurawald.fuji.module.initializer.works.gui.CreateWorkGui;
import io.github.sakurawald.fuji.module.initializer.works.structure.work.abst.Work;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListWorksGui
extends PagedGui<Work> {
    public ListWorksGui(class_3222 player, @NotNull List<Work> entities, int pageIndex) {
        super(null, player, TextHelper.getTextByKey(player, "works.list.title", new Object[0]), entities, pageIndex);
        this.getFooter().setSlot(3, GuiHelper.makeAddButton(player).setName(TextHelper.getTextByKey(player, "works.list.add", new Object[0])).setCallback(() -> new CreateWorkGui(player).open()));
        this.getFooter().setSlot(4, (GuiElementBuilderInterface)GuiHelper.makeHelpButton(player).setLore(TextHelper.getTextListByKey(player, "works.list.help.lore")));
        if (ListWorksGui.isViewingAllWorks(entities)) {
            this.getFooter().setSlot(5, GuiHelper.makeLetterAButton(player).setName(TextHelper.getTextByKey(player, "works.list.my_works", new Object[0])).setCallback(() -> this.linkCurrentGuiAndSearch(player.method_7334().getName()).open()));
        } else {
            this.getFooter().setSlot(5, GuiHelper.makeHeartButton(player).setName(TextHelper.getTextByKey(player, "works.list.all_works", new Object[0])).setCallback(() -> new ListWorksGui(player, WorksInitializer.works.model().works, 0).open()));
        }
    }

    @Override
    protected PagedGui<Work> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<Work> entities, int pageIndex) {
        return new ListWorksGui(player, entities, pageIndex);
    }

    private static boolean isViewingAllWorks(@NotNull List<Work> entities) {
        return entities == WorksInitializer.works.model().works;
    }

    private boolean canOperateOnThisEntity(@NotNull class_3222 player, @NotNull Work work) {
        return PlayerHelper.getPlayerName((class_1657)player).equals(work.creator) || player.method_5687(4);
    }

    @Override
    protected GuiElementInterface toGuiElement(@NotNull Work entity) {
        class_3222 player = this.getPlayer();
        return new GuiElementBuilder().setItem(entity.getEntityIcon()).setName(TextHelper.getTextByValue(null, entity.name, new Object[0])).setLore(entity.ofLore(player)).setCallback(this.handleClick(entity, player)).build();
    }

    private GuiElementInterface.ItemClickCallback handleClick(@NotNull Work entity, class_3222 player) {
        return (index, clickType, actionType) -> {
            if (clickType.isLeft) {
                class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)RegistryHelper.makeIdentifier(entity.level));
                class_3218 level = ServerHelper.getServer().method_3847(worldKey);
                if (level != null) {
                    new GlobalPos((class_1937)level, entity.x, entity.y, entity.z, entity.yaw, entity.pitch).teleport(player);
                } else {
                    TextHelper.sendTextByKey(player, "world.dimension.not_found", entity.level);
                }
                this.close();
                return;
            }
            if (clickType.isRight && clickType.shift) {
                if (!this.canOperateOnThisEntity(player, entity)) {
                    TextHelper.sendTextByKey(player, "works.work.set.no_perm", new Object[0]);
                    return;
                }
                entity.openSpecializedSettingsGui(player, (SimpleGui)this.gui);
                this.close();
                return;
            }
            if (clickType.isRight) {
                if (!this.canOperateOnThisEntity(player, entity)) {
                    TextHelper.sendTextByKey(player, "works.work.set.no_perm", new Object[0]);
                    return;
                }
                entity.openGeneralSettingsGui(player, (SimpleGui)this.gui);
                this.close();
            }
        };
    }
}

