/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.world;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.DimensionType;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.Cite;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.world.config.model.WorldConfigModel;
import io.github.sakurawald.fuji.module.initializer.world.config.model.WorldDataModel;
import io.github.sakurawald.fuji.module.initializer.world.gui.WorldGui;
import io.github.sakurawald.fuji.module.initializer.world.service.WorldService;
import io.github.sakurawald.fuji.module.initializer.world.structure.RuntimeDimensionDescriptor;
import io.github.sakurawald.fuji.module.initializer.world.structure.gamerule.BooleanGameRuleMapAdapter;
import io.github.sakurawald.fuji.module.initializer.world.structure.gamerule.GameRuleStore;
import io.github.sakurawald.fuji.module.initializer.world.structure.gamerule.IntegerGameRuleMapAdapter;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_6673;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Cite(value={"https://github.com/NucleoidMC/fantasy"})
@Document(id=1751826605981L, value="Provides a unified world management.\n")
@ColorBoxes(value={@ColorBox(id=1751981919874L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 The definition of `world`, ` dimension` and `dimension type`.\nIn early Minecraft, a `world` only contains `1 dimension` (The overworld dimension).\nIn modern Minecraft, a `world` can contain `3 or more dimensions`. (The overworld, the end and the nether)\n\nEach `dimension` has its `dimension type`.\nThe `dimension type` defines the `chunk generator`.\n\nSee also: https://minecraft.wiki/w/Dimension_definition\nSee also: https://minecraft.wiki/w/Dimension_type\n\n<green>NOTE: You can just think the `dimension` word is identical to `world`.\n"), @ColorBox(id=1752458381916L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 How it works?\nIn vanilla Minecraft, there is a variable `worlds` in `server`, used to store all `loaded dimensions`.\n\nThe vanilla Minecraft will `load` the 3 `dimensions` on server startup.\nThey are `minecraft:overworld`, `minecraft:the_nether` and `minecraft:the_end`.\n\nSo, what we should do is to `imitate` the actions.\nWe make the `dimension` instance at server startup.\nAnd then we put the `dimension` in the `loaded dimensions` list.\nSo it will be recognised by the server.\n\nNOTE: The dimensions created by fuji is named `runtime dimension`, because they are `created` and `loaded` at runtime.\n\n\u25c9 Does it need to store any special data in the `world` folder?\nNo, we didn't touch the `world` folder, or put any special data into it.\n\nWhat we need is minimal, we need to define `runtime dimension descriptor` in the module folder.\nThe `runtime dimension descriptor` should provide these information: `dimension id`, `dimension type id`, `seed`.\n"), @ColorBox(id=1752458991398L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 How the `world` module generate the dimension?\nActually, the `world` module didn't do the `world generation` itself.\n\nA `dimension` is composed by `chunks` (A `16x16 segment` of the `dimension`)\nThe `dimension type` defines the `chunk generator`.\n\nSo, what we do is simple, the `runtime dimension descriptor` needs to specify the `dimension type`.\nAnd we will use the existing `chunk generator` defined by that `dimension type`.\n\n\u25c9 How the `chunk generator` works?\nA `chunk generator` need to `fill blocks` in the `given chunk location`.\nYou need to give the `seed` to `the chunk generator`, and it will fill blocks for you.\n\nIf the specified chunk is not `generated`, then the chunk generator will `generated` a new one.\nIf the specified chunk is `generated`, the chunk generator will just use the `existed chunk data` in storage.\n"), @ColorBox(id=1752297520453L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 Advanced World Management and Per-world rules.\nThe `world` module provided by fuji is a simple module.\nIf you want a more powerful tool, you can try use `WorldManager` mod and `WorldGameRules` mod.\n\nSee:\n1. https://github.com/DrexHD/WorldManager\n2. https://github.com/DrexHD/WorldGameRules\n"), @ColorBox(id=1751982071236L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Create an extra `the_nether` dimension\nIssue: `/world create my_nether minecraft:the_nether`\n\n\u25c9 Delete the extra dimension\nIssue: `/world delete fuji:my_nether --confirm true`\n\n\u25c9 Reset the extra dimension with random seed.\nIssue: `/world reset fuji:my_nether --confirm true`\n\n\u25c9 Specify a seed for an extra dimension.\n1. `/world create my_nether --seed 1234567890 minecraft:the_nether`\n2. `/world reset fuji:my_nether --useTheSameSeed true --confirm true`\n"), @ColorBox(id=1751982158414L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 Make a resource world that reset automatically every day.\nYou can use `command_scheduler` module, to execute `/world reset` command automatically.\n"), @ColorBox(id=1752261661452L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 The logic of `passed ticks` is per-dimension.\nEach fuji runtime dimension will save its own `time_of_day` (The equivalent to `DayTime` in `level.dat`).\n\n\u25c9 The duration of `one day` in Minecraft.\nThe `total ticks of one day` is `24000 ticks` or `20 minutes`.\nIt is `10 minutes of day time` + `10 minutes of night time`.\n\n\u25c9 The saved `passed ticks` and `/time` command.\nThe value of `Time` in `level.dat` = `/time query gametime`.\nThe value of `DayTime` in `level.dat` = `/time query day` * 24000 + `/time query daytime`.\n\nNOTE: The `minecraft:overworld`, `minecraft:the_nether` and `minecraft:the_end` shares the same instance of `DayTime`.\nNOTE: The `/time set {day/midnight/night/noon} command directly sets the `DayTime` to the first day.\n\n\u25c9 The logic of `/time query ...` command.\nFor `/time query daytime` command, it returns the `DayTime % 24000` of `the world of the command source`:\n1. If the `command source` is `a player`, then the `world` is `the world where the player is`.\n2. If the `command source` is `the console`, then the `world` is `minecraft:overworld`.\n\n\u25c9 The logic of `/time {set/add} ...` command.\nFor command `/time {set/add}`, it operates on `all dimensions` in the server.\n"), @ColorBox(id=1752287089199L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 The `weather system` of the `world`.\nThere are 3 types of `weather`: `clear`, `rain` and `thunder`.\nIf `clear`, then both `rain` and `thunder` is false.\nIf `thunder`, then `rain` is true.\n\nThe `weather system` will be `tick` if:\n1. The `dimension options` of the `world` has `skylight`.\n2. The `gamerule DO_WEATHER_CYCLE` of the `world` is true.\n\n\u25c9 The logic of `/weather` command.\nThe `/weather` command `only` sets the `weather` of `minecraft:overworld`.\n\n\u25c9 Set the weather per-dimension.\nYou can modify the weather directly in config file, and issue `/fuji reload` to apply it.\n"), @ColorBox(id=1752292508145L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 The logic of `/gamerule` command.\nThe `/gamerule` command `only` operates on `minecraft:overworld` dimension.\n\nTo see the `true info` of `a specified dimension`, you should use `/world info` command.\n\n\u25c9 Set the `per-dimension gamerules` using commands.\nYou can install the `WorldGameRules` mod to provide such commands.\nSee https://github.com/DrexHD/WorldGameRules\n"), @ColorBox(id=1752429441664L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 Does the `runtime dimension` support `datapack`?\nIt depends on how the `datapack` interfaces with the `world`.\nMost of datapack should work.\nAnyway, always backup your world data before install a new datapack.\n"), @ColorBox(id=1752431019812L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 The logic of `nether portal` and `ender portal`.\nIn vanilla Minecraft, there are only 3 dimensions.\nThey are `minecraft:overworld`, `minecraft:the_nether` and `minecraft:the_end`.\nThey are `hard coded` dimensions.\nThe linkage of `nether portal` and `ender portal` use the `hard coded` dimensions.\n\n\u25c9 Can I create `nether portal` in `runtime dimension`?\nNo, you can't create any `nether portal` in runtime dimension.\n\n\u25c9 Can I create `ender portal` in `runtime dimension`?\nYes, but the destination dimension is hard-coded, it is always the `minecraft:the_end`.\n\nThe logic of `EnderPortalBlockEntity`:\n1. If the player is now in `minecraft:the_end`, then destination dimension is `minecraft:overworld`.\n2. Else the destination dimension is `minecraft:the_end`.\n")})
@CommandNode(value="world")
@CommandRequirement(level=4)
public class WorldInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<WorldConfigModel> config = new ObjectConfigurationHandler<WorldConfigModel>("config.json", WorldConfigModel.class);
    public static final BaseConfigurationHandler<WorldDataModel> storage = new ObjectConfigurationHandler<WorldDataModel>("world.json", WorldDataModel.class).setAutoSaveEveryMinute();

    private static void checkBlacklist(class_2168 source, String identifier) {
        if (WorldInitializer.config.model().blacklist.dimension_list.contains(identifier)) {
            TextHelper.sendTextByKey(source, "world.dimension.blacklist", identifier);
            throw new AbortCommandExecutionException();
        }
    }

    private static void ensureDimensionIdNotExists(class_2168 source, class_2960 identifier) {
        if (WorldService.existsDimension(identifier)) {
            TextHelper.sendTextByKey(source, "world.dimension.exist", new Object[0]);
            throw new AbortCommandExecutionException();
        }
    }

    @Document(id=1751826609063L, value="Teleport to the target dimension with the same coordinate.")
    @CommandNode(value="tp")
    private static int $tp(@CommandSource class_3222 player, Dimension dimension) {
        class_3218 targetDimension = (class_3218)dimension.getValue();
        GlobalPos.of(player).withLevel(RegistryHelper.toString((class_1937)targetDimension)).teleport(player);
        return 1;
    }

    @CommandNode(value="list")
    private static int $list(@CommandSource class_2168 source) {
        if (source.method_43737()) {
            List<RuntimeDimensionDescriptor> entities = WorldInitializer.storage.model().dimension_list;
            new WorldGui(source.method_44023(), entities, 0).open();
        } else {
            ServerHelper.getWorlds().forEach(world -> {
                String dimensionType = RegistryHelper.getIdAsString(world.method_40134());
                String dimension = String.valueOf(world.method_27983().method_29177());
                TextHelper.sendTextByKey(source, "world.dimension.list.entry", dimension, dimensionType);
            });
        }
        return 1;
    }

    @CommandNode(value="create")
    private static int $create(@CommandSource class_2168 source, String name, DimensionType dimensionType, Optional<Long> seed) {
        String FUJI_DIMENSION_NAMESPACE = "fuji";
        class_2960 dimensionIdentifier = class_2960.method_43902((String)"fuji", (String)name);
        WorldInitializer.ensureDimensionIdNotExists(source, dimensionIdentifier);
        long $seed = seed.orElse(class_6673.method_39001());
        class_2960 dimensionTypeIdentifier = RegistryHelper.makeIdentifier((String)dimensionType.getValue());
        RuntimeDimensionDescriptor runtimeDimensionDescriptor = new RuntimeDimensionDescriptor();
        runtimeDimensionDescriptor.dimension = dimensionIdentifier.toString();
        runtimeDimensionDescriptor.dimension_type = dimensionTypeIdentifier.toString();
        runtimeDimensionDescriptor.seed = $seed;
        runtimeDimensionDescriptor.setShouldTickTime(true);
        runtimeDimensionDescriptor.gameRules = GameRuleStore.makeDefault();
        WorldInitializer.storage.model().dimension_list.add(runtimeDimensionDescriptor);
        storage.writeStorage();
        WorldService.requestToCreateDimension(runtimeDimensionDescriptor);
        TextHelper.sendBroadcastByKey("world.dimension.created", dimensionIdentifier);
        return 1;
    }

    @CommandNode(value="delete")
    private static int $delete(@CommandSource class_2168 source, Dimension dimension, Optional<Boolean> confirm) {
        class_3218 dimensionInstance = (class_3218)dimension.getValue();
        String dimensionId = RegistryHelper.toString((class_1937)dimensionInstance);
        WorldInitializer.checkBlacklist(source, dimensionId);
        if (!CommandHelper.Pattern.isCommandConfirmed(source, confirm)) {
            return -1;
        }
        WorldService.requestToDeleteDimension(dimensionInstance);
        WorldService.deleteDimensionNode(dimensionId);
        TextHelper.sendBroadcastByKey("world.dimension.deleted", dimensionId);
        return 1;
    }

    @Document(id=1751826611302L, value="Delete and create the specified world.")
    @CommandNode(value="reset")
    private static int $reset(@CommandSource class_2168 source, Dimension dimension, Optional<Boolean> useTheSameSeed, Optional<Boolean> confirm) {
        if (!CommandHelper.Pattern.isCommandConfirmed(source, confirm)) {
            return -1;
        }
        class_3218 dimensionInstance = (class_3218)dimension.getValue();
        String dimensionIdentifier = RegistryHelper.toString((class_1937)dimensionInstance);
        WorldInitializer.checkBlacklist(source, dimensionIdentifier);
        Optional<RuntimeDimensionDescriptor> dimensionEntryOpt = WorldService.getDimensionDescriptor(dimensionIdentifier);
        if (dimensionEntryOpt.isEmpty()) {
            TextHelper.sendTextByKey(source, "world.dimension.not_found", new Object[0]);
            return -1;
        }
        RuntimeDimensionDescriptor runtimeDimensionDescriptor = dimensionEntryOpt.get();
        WorldService.requestToDeleteDimension(dimensionInstance);
        Boolean $useTheSameSeed = useTheSameSeed.orElse(false);
        runtimeDimensionDescriptor.seed = $useTheSameSeed != false ? runtimeDimensionDescriptor.seed : class_6673.method_39001();
        storage.writeStorage();
        WorldService.requestToCreateDimension(runtimeDimensionDescriptor);
        TextHelper.sendBroadcastByKey("world.dimension.reset", dimensionIdentifier);
        return 1;
    }

    @Document(id=1752248825291L, value="Saves the config of all extra dimensions into the storage.\n")
    @CommandNode(value="save-configs")
    @CommandRequirement(level=4)
    private static int $saveConfigs(@CommandSource class_2168 source) {
        WorldService.saveRuntimeWorldConfigs();
        TextHelper.sendTextByKey(source, "operation.success", new Object[0]);
        return 1;
    }

    @Document(id=1752433782557L, value="List the dimensions each player is in.\n")
    @CommandNode(value="who")
    @CommandRequirement(level=4)
    private static int $who(@CommandSource class_2168 source) {
        WorldInitializer.printGroupedPlayersByDimension(source, null);
        return 1;
    }

    @Document(id=1752434557605L, value="List the players in specified dimension.\n")
    @CommandNode(value="who")
    @CommandRequirement(level=4)
    private static int $who(@CommandSource class_2168 source, Dimension dimension) {
        WorldInitializer.printGroupedPlayersByDimension(source, dimension);
        return 1;
    }

    @Document(id=1752435062516L, value="Query which dimension the player is in.\n")
    @CommandNode(value="who")
    @CommandRequirement(level=4)
    private static int $who(@CommandSource class_2168 source, class_3222 player) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        String locationDimensionId = RegistryHelper.toString(player.method_37908());
        TextHelper.sendTextByKey(source, "world.who.player", playerName, locationDimensionId);
        return 1;
    }

    private static void printGroupedPlayersByDimension(class_2168 source, @Nullable Dimension specifiedDimension) {
        Map<@NotNull String, List> groupedPlayers = ServerHelper.getWorlds().stream().collect(Collectors.toMap(RegistryHelper::toString, world -> world.method_18456().stream().map(PlayerHelper::getPlayerName).toList()));
        groupedPlayers.entrySet().stream().filter(entry -> {
            if (specifiedDimension == null) {
                return true;
            }
            String filterDimension = RegistryHelper.toString((class_1937)specifiedDimension.getValue());
            return ((String)entry.getKey()).equals(filterDimension);
        }).forEach(entry -> {
            String dimensionId = (String)entry.getKey();
            List players = (List)entry.getValue();
            TextHelper.sendTextByKey(source, "world.who.dimension", dimensionId, players);
        });
    }

    @Document(id=1752283075945L, value="List the debug info of specified dimension.\n")
    @CommandNode(value="info")
    @CommandRequirement(level=4)
    private static int $info(@CommandSource class_2168 source, Dimension dimension) {
        class_3218 dimensionInstance = (class_3218)dimension.getValue();
        TextHelper.sendTextByKey(source, "dimension.id", RegistryHelper.toString((class_1937)dimensionInstance));
        TextHelper.sendTextByKey(source, "dimension.difficulty", dimensionInstance.method_8407());
        TextHelper.sendTextByKey(source, "dimension.seed", dimensionInstance.method_8412());
        TextHelper.sendTextByKey(source, "dimension.options", dimensionInstance.method_8597());
        TextHelper.sendTextByKey(source, "dimension.properties", dimensionInstance.method_8401());
        TextHelper.sendTextByKey(source, "dimension.chunk_generator", dimensionInstance.method_14178().method_12129());
        class_2784 worldBorder = dimensionInstance.method_8621();
        TextHelper.sendTextByKey(source, "dimension.border", new Object[0]);
        TextHelper.sendTextByKey(source, "dimension.border.size", worldBorder.method_11965());
        TextHelper.sendTextByKey(source, "dimension.border.size.lerp_target", worldBorder.method_11954());
        TextHelper.sendTextByKey(source, "dimension.border.size.lerp_time", worldBorder.method_11962());
        TextHelper.sendTextByKey(source, "dimension.border.center.x", worldBorder.method_11964());
        TextHelper.sendTextByKey(source, "dimension.border.center.z", worldBorder.method_11980());
        TextHelper.sendTextByKey(source, "dimension.border.damage.per_block", worldBorder.method_11953());
        TextHelper.sendTextByKey(source, "dimension.border.safe_zone", worldBorder.method_11971());
        TextHelper.sendTextByKey(source, "dimension.border.warning.blocks", worldBorder.method_11972());
        TextHelper.sendTextByKey(source, "dimension.border.warning.time", worldBorder.method_11956());
        class_5250 gameRulesText = TextHelper.getTextByKey(source, "dimension.gamerules", new Object[0]).method_27661();
        final HashMap gameRulesMap = new HashMap();
        final class_1928 gameRules = dimensionInstance.method_8450();
        class_1928.method_20744((class_1928.class_4311)new class_1928.class_4311(){

            public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
                String gameRuleName = key.method_20771();
                class_1928.class_4315 gameRuleValue = gameRules.method_20746(key);
                gameRulesMap.put(gameRuleName, gameRuleValue);
            }
        });
        class_5250 gameRulesHoverText = TextHelper.Formatter.formatMap(gameRulesMap);
        gameRulesText.method_27696(class_2583.field_24360.method_10949(TextHelper.Events.HoverEvent.makeShowTextAction((class_2561)gameRulesHoverText)));
        source.method_45068((class_2561)gameRulesText);
        TextHelper.sendTextByKey(source, "prompt.hover.see_it", new Object[0]);
        return 1;
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(this::loadDimensions);
    }

    @Override
    protected void registerGsonTypeAdapter() {
        BaseConfigurationHandler.registerGsonTypeAdapter(Reference2BooleanMap.class, new BooleanGameRuleMapAdapter());
        BaseConfigurationHandler.registerGsonTypeAdapter(Reference2IntMap.class, new IntegerGameRuleMapAdapter());
    }

    private void loadDimensions(@NotNull MinecraftServer server) {
        WorldInitializer.storage.model().dimension_list.stream().filter(RuntimeDimensionDescriptor::isAuto_load_on_server_startup).forEach(it -> {
            try {
                WorldService.requestToCreateDimension(it);
                LogUtil.info("Load dimension {} into the server.", it.getDimension());
            }
            catch (Exception e) {
                LogUtil.error("Failed to load dimension `{}`", it, e);
            }
        });
    }
}

