/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.world.border;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.world.border.config.model.WorldBorderConfigModel;
import io.github.sakurawald.fuji.module.initializer.world.border.structure.BorderDescriptor;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2596;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5895;
import net.minecraft.class_5896;
import net.minecraft.class_5897;
import net.minecraft.class_5898;
import net.minecraft.class_5899;

@Document(id=1752561532728L, value="This module allows you to customize the `per-dimension world border`.\n")
@ColorBoxes(value={@ColorBox(id=1752460350802L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 The logic of `/worldborder` command.\nThe `/worldborder` command only sets the `World Border` of `minecraft:overworld`.\nBut the `minecraft:the_nether` and `minecraft:the_end` dimensions will `sync` the `world border` of `minecraft:overworld`.\n"), @ColorBox(id=1752569349615L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 The semantics of options for `world border`.\nSee: https://minecraft.wiki/w/World_border\n")})
public class WorldBorderInitializer
extends ModuleInitializer {
    public static BaseConfigurationHandler<WorldBorderConfigModel> config = new ObjectConfigurationHandler<WorldBorderConfigModel>("config.json", WorldBorderConfigModel.class);

    public static Optional<BorderDescriptor> getBorderDescriptor(String dimensionId) {
        return WorldBorderInitializer.config.model().borders.stream().filter(it -> it.dimensionId.equals(dimensionId)).findFirst();
    }

    @Override
    protected void onReload() {
        WorldBorderInitializer.sendPerDimensionWorldBorderPackets();
    }

    private static void sendPerDimensionWorldBorderPackets() {
        WorldBorderInitializer.sendPerDimensionWorldBorderPacket(dimension -> new class_5895(dimension.method_8621()));
        WorldBorderInitializer.sendPerDimensionWorldBorderPacket(dimension -> new class_5897(dimension.method_8621()));
        WorldBorderInitializer.sendPerDimensionWorldBorderPacket(dimension -> new class_5896(dimension.method_8621()));
        WorldBorderInitializer.sendPerDimensionWorldBorderPacket(dimension -> new class_5899(dimension.method_8621()));
        WorldBorderInitializer.sendPerDimensionWorldBorderPacket(dimension -> new class_5898(dimension.method_8621()));
    }

    public static void sendPerDimensionWorldBorderPacket(Function<class_3218, class_2596<?>> packetProvider) {
        ServerHelper.getWorlds().forEach(dimension -> {
            class_2784 perDimensionWorldBorder = dimension.method_8621();
            class_5321 dimensionRegistryKey = dimension.method_27983();
            class_2596 packet = (class_2596)packetProvider.apply((class_3218)dimension);
            ServerHelper.getPlayerManager().method_14589(packet, dimensionRegistryKey);
        });
    }
}

