/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.world.service;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.event.impl.ServerTickEvents;
import io.github.sakurawald.fuji.core.event.impl.ServerWorldEvents;
import io.github.sakurawald.fuji.core.extension.SimpleRegistryExtension;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.core.structure.TeleportTicket;
import io.github.sakurawald.fuji.module.initializer.world.WorldInitializer;
import io.github.sakurawald.fuji.module.initializer.world.accessor.ExtendedDimensionOptions;
import io.github.sakurawald.fuji.module.initializer.world.structure.RuntimeDimension;
import io.github.sakurawald.fuji.module.initializer.world.structure.RuntimeDimensionDescriptor;
import io.github.sakurawald.fuji.module.initializer.world.structure.RuntimeDimensionProperties;
import io.github.sakurawald.fuji.module.initializer.world.structure.VoidWorldGenerationProgressListener;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2881;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4543;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7134;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldService {
    private static final Set<class_3218> dimensionDeletionQueue = new ReferenceOpenHashSet();
    private static final Set<RuntimeDimensionDescriptor> dimensionCreationQueue = new ReferenceOpenHashSet();

    private static void processDimensionCreationAndDeletionQueue() {
        dimensionDeletionQueue.removeIf(WorldService::tryDeleteDimension);
        dimensionCreationQueue.removeIf(WorldService::tryCreateDimension);
    }

    public static void requestToDeleteDimension(@NotNull class_3218 world) {
        ServerHelper.getServer().method_20493(() -> dimensionDeletionQueue.add(world));
    }

    public static void requestToCreateDimension(RuntimeDimensionDescriptor runtimeDimensionDescriptor) {
        ServerHelper.getServer().method_20493(() -> dimensionCreationQueue.add(runtimeDimensionDescriptor));
    }

    private static boolean tryDeleteDimension(@NotNull class_3218 world) {
        if (world.method_18456().isEmpty()) {
            WorldService.deleteDimension(world);
            return true;
        }
        WorldService.evacuatePlayers(world);
        return false;
    }

    private static boolean tryCreateDimension(@NotNull RuntimeDimensionDescriptor runtimeDimensionDescriptor) {
        if (dimensionDeletionQueue.stream().anyMatch(it -> RegistryHelper.toString((class_1937)it).equals(runtimeDimensionDescriptor.dimension))) {
            return false;
        }
        WorldService.createDimension(runtimeDimensionDescriptor);
        return true;
    }

    private static void createDimension(@NotNull RuntimeDimensionDescriptor runtimeDimensionDescriptor) {
        RuntimeDimension dimension;
        MinecraftServer server = ServerHelper.getServer();
        class_2960 dimensionIdentifier = RegistryHelper.makeIdentifier(runtimeDimensionDescriptor.dimension);
        class_2960 dimensionTypeIdentifier = RegistryHelper.makeIdentifier(runtimeDimensionDescriptor.dimension_type);
        RuntimeDimensionProperties worldProperties = new RuntimeDimensionProperties(server.method_27728(), runtimeDimensionDescriptor);
        @Nullable class_5363 dimensionOptions = WorldService.makeDimensionOptions(dimensionTypeIdentifier);
        if (dimensionOptions == null) {
            LogUtil.error("Can't use {} dimension-type as the template to create extra fuji worlds.", dimensionTypeIdentifier);
            return;
        }
        ((ExtendedDimensionOptions)dimensionOptions).fuji$setSaveDimensionOptions(false);
        class_5321 worldRegistryKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimensionIdentifier);
        LogUtil.debug("Make instance of world with registry key of type `World`: {}", worldRegistryKey);
        try {
            dimension = new RuntimeDimension(server, class_156.method_18349(), server.field_23784, (class_5268)worldProperties, (class_5321<class_1937>)worldRegistryKey, dimensionOptions, VoidWorldGenerationProgressListener.INSTANCE, false, class_4543.method_27984((long)runtimeDimensionDescriptor.seed), (List<class_5304>)ImmutableList.of(), runtimeDimensionDescriptor.shouldTickTime, null);
        }
        catch (Exception e) {
            LogUtil.error("Failed to make ServerWorld instance: dimensionId = {}, dimensionTypeId = {}", dimensionIdentifier, dimensionTypeIdentifier, e);
            return;
        }
        if (dimensionTypeIdentifier.equals((Object)class_7134.field_37672)) {
            dimension.method_51837(new class_2881((class_3218)dimension, dimension.method_8412(), class_2881.class_8576.field_44946));
        }
        class_2370 dimensionOptionsRegistry = (class_2370)RegistryHelper.ofRegistry(class_7924.field_41224);
        boolean original = ((SimpleRegistryExtension)dimensionOptionsRegistry).fuji$isFrozen();
        ((SimpleRegistryExtension)dimensionOptionsRegistry).fuji$setFrozen(false);
        class_5321 dimensionOptionsRegistryKey = class_7924.method_47518((class_5321)worldRegistryKey);
        if (!dimensionOptionsRegistry.method_35842(dimensionOptionsRegistryKey)) {
            LogUtil.debug("Add entry for dimension options registry: key = {}, value = {}", dimensionOptionsRegistryKey, dimensionOptions);
            dimensionOptionsRegistry.method_10272(dimensionOptionsRegistryKey, (Object)dimensionOptions, Lifecycle.stable());
        }
        ((SimpleRegistryExtension)dimensionOptionsRegistry).fuji$setFrozen(original);
        server.field_4589.put(dimension.method_27983(), dimension);
        ServerWorldEvents.LOAD.invoker().fire(server, dimension);
        dimension.method_18765(() -> true);
    }

    private static void evacuatePlayers(@NotNull class_3218 dimension) {
        class_3218 safeDimension = dimension.method_8503().method_30002();
        class_2338 safeBlockPos = safeDimension.method_43126();
        ArrayList players = new ArrayList(dimension.method_18456());
        for (class_3222 player : players) {
            GlobalPos from = GlobalPos.of(player);
            GlobalPos to = new GlobalPos((class_1937)safeDimension, (double)safeBlockPos.method_10263() + 0.5, (double)safeBlockPos.method_10264() + 0.5, (double)safeBlockPos.method_10260() + 0.5, 0.0f, 0.0f);
            TeleportTicket teleportTicket = TeleportTicket.makeVipTicket(player, from, to);
            Managers.getBossBarManager().addTicket(teleportTicket);
        }
    }

    private static void deleteDimension(@NotNull class_3218 world) {
        MinecraftServer server = world.method_8503();
        class_5321 dimensionKey = world.method_27983();
        if (server.field_4589.remove(dimensionKey, world)) {
            ServerWorldEvents.UNLOAD.invoker().fire(server, world);
            class_2370 dimensionsRegistry = (class_2370)RegistryHelper.ofRegistry(class_7924.field_41224);
            SimpleRegistryExtension.remove(dimensionsRegistry, dimensionKey.method_29177());
            File worldDirectory = server.field_23784.method_27424(dimensionKey).toFile();
            WorldService.deleteFiles(worldDirectory);
        }
    }

    private static void deleteFiles(@NotNull File file) {
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File child : files) {
                if (child.isDirectory()) {
                    WorldService.deleteFiles(child);
                    continue;
                }
                child.delete();
            }
        }
    }

    @Nullable
    private static class_5363 makeDimensionOptions(class_2960 dimensionTypeIdentifier) {
        class_2378 registry = RegistryHelper.ofRegistry(class_7924.field_41224);
        @Nullable class_5363 originalDimensionOptions = (class_5363)registry.method_10223(dimensionTypeIdentifier);
        if (originalDimensionOptions == null) {
            return null;
        }
        return new class_5363(originalDimensionOptions.comp_1012(), originalDimensionOptions.comp_1013());
    }

    public static boolean existsDimension(class_2960 dimensionId) {
        return ServerHelper.getWorlds().stream().anyMatch(it -> RegistryHelper.toString((class_1937)it).equals(dimensionId.toString()));
    }

    public static void deleteDimensionNode(String dimensionId) {
        Optional<RuntimeDimensionDescriptor> first = WorldInitializer.storage.model().dimension_list.stream().filter(o -> o.getDimension().equals(dimensionId)).findFirst();
        first.ifPresent(dimensionNode -> {
            WorldInitializer.storage.model().dimension_list.remove(dimensionNode);
            WorldInitializer.storage.writeStorage();
        });
    }

    public static void saveRuntimeWorldConfigs() {
        WorldInitializer.config.writeStorage();
    }

    public static Optional<RuntimeDimensionDescriptor> getDimensionDescriptor(String dimensionId) {
        return WorldInitializer.storage.model().dimension_list.stream().filter(it -> it.dimension.equalsIgnoreCase(dimensionId)).findFirst();
    }

    static {
        ServerTickEvents.START_SERVER_TICK.register(server -> WorldService.processDimensionCreationAndDeletionQueue());
    }
}

