/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.world.structure;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.module.initializer.world.service.WorldService;
import io.github.sakurawald.fuji.module.initializer.world.structure.RuntimeDimensionDescriptor;
import io.github.sakurawald.fuji.module.initializer.world.structure.RuntimeDimensionProperties;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3949;
import net.minecraft.class_5268;
import net.minecraft.class_5269;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_8565;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimeDimension
extends class_3218 {
    public RuntimeDimension(MinecraftServer server, Executor workerExecutor, class_32.class_5143 session, class_5268 properties, class_5321<class_1937> worldKey, class_5363 dimensionOptions, class_3949 worldGenerationProgressListener, boolean debugWorld, long seed, List<class_5304> spawners, boolean shouldTickTime, @Nullable class_8565 randomSequencesState) {
        super(server, workerExecutor, session, properties, worldKey, dimensionOptions, worldGenerationProgressListener, debugWorld, seed, spawners, shouldTickTime, randomSequencesState);
    }

    private Optional<RuntimeDimensionProperties> getRuntimeDimensionProperties() {
        class_5269 class_52692 = this.field_9232;
        if (class_52692 instanceof RuntimeDimensionProperties) {
            RuntimeDimensionProperties runtimeDimensionProperties = (RuntimeDimensionProperties)class_52692;
            return Optional.of(runtimeDimensionProperties);
        }
        return Optional.empty();
    }

    public long method_8412() {
        String dimensionId = this.getThisDimensionId();
        Optional<RuntimeDimensionDescriptor> dimensionNode = WorldService.getDimensionDescriptor(dimensionId);
        if (dimensionNode.isPresent()) {
            return dimensionNode.get().seed;
        }
        long fallbackSeed = super.method_8412();
        LogUtil.warn("Failed to set the custom seed for dimension {}, we will use the fallback seed {} instead.", dimensionId, fallbackSeed);
        return fallbackSeed;
    }

    @NotNull
    private String getThisDimensionId() {
        String dimensionId = RegistryHelper.toString(this.method_27983());
        return dimensionId;
    }

    protected void method_29203() {
        this.getRuntimeDimensionProperties().ifPresentOrElse(runtimeDimensionProperties -> {
            if (!runtimeDimensionProperties.getEffectiveRuntimeDimensionDescriptor().shouldTickTime) {
                return;
            }
            if (runtimeDimensionProperties.method_146().method_8355(class_1928.field_19396)) {
                runtimeDimensionProperties.method_29035(runtimeDimensionProperties.method_217() + 1L);
            }
        }, () -> super.method_29203());
    }

    public class_1928 method_8450() {
        return this.getRuntimeDimensionProperties().map(RuntimeDimensionProperties::method_146).orElseGet(() -> super.method_8450());
    }
}

