/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.world.structure;

import com.google.gson.annotations.SerializedName;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.world.structure.gamerule.GameRuleStore;
import net.minecraft.class_1267;
import net.minecraft.class_1928;
import net.minecraft.class_1937;

@Document(id=1752170874671L, value="A `dimension descriptor` is used to describe a `runtime dimension`.\nIt contains the important info about a `dimension`, like the `dimension id`, `dimension type` and `seed`...\n")
public class RuntimeDimensionDescriptor {
    @Document(id=1752170969085L, value="Should we `load` this `dimension` on server startup?\n")
    @SerializedName(value="auto_load_on_server_startup", alternate={"enable"})
    public boolean auto_load_on_server_startup = true;
    @Document(id=1752170986625L, value="The `identifier` of this `dimension`.\n")
    public String dimension;
    @Document(id=1752171006784L, value="The `dimension type` of this `dimension`.\nNote that the `dimension type` defines the `chunk generator` and `dimension features`.\n")
    @SerializedName(value="dimension_type", alternate={"dimensionType"})
    public String dimension_type;
    @Document(id=1752246679197L, value="The `seed` used for the `chunk generator` of this dimension.\n")
    public long seed;
    public class_1267 difficulty = class_1267.field_5802;
    public GameRuleStore gameRules = new GameRuleStore();
    @Document(id=1752246657296L, value="Should we tick the time of this `dimension`? (Do the day night cycle?)\n")
    public boolean shouldTickTime;
    @Document(id=1752286206946L, value="The equivalent to `DayTime` in `level.dat`.\n")
    public long timeOfDay = 6000L;
    public Weather weather = new Weather();

    public void setShouldTickTime(boolean shouldTickTime) {
        this.shouldTickTime = shouldTickTime;
        this.gameRules.setBooleanRule((class_1928.class_4313<class_1928.class_4310>)class_1928.field_19396, shouldTickTime);
    }

    public boolean isDimensionLoaded() {
        return ServerHelper.getWorlds().stream().anyMatch(it -> RegistryHelper.toString((class_1937)it).equals(this.dimension));
    }

    public boolean isAuto_load_on_server_startup() {
        return this.auto_load_on_server_startup;
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getDimension_type() {
        return this.dimension_type;
    }

    public long getSeed() {
        return this.seed;
    }

    public class_1267 getDifficulty() {
        return this.difficulty;
    }

    public GameRuleStore getGameRules() {
        return this.gameRules;
    }

    public boolean isShouldTickTime() {
        return this.shouldTickTime;
    }

    public long getTimeOfDay() {
        return this.timeOfDay;
    }

    public Weather getWeather() {
        return this.weather;
    }

    public void setAuto_load_on_server_startup(boolean auto_load_on_server_startup) {
        this.auto_load_on_server_startup = auto_load_on_server_startup;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public void setDimension_type(String dimension_type) {
        this.dimension_type = dimension_type;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setDifficulty(class_1267 difficulty) {
        this.difficulty = difficulty;
    }

    public void setGameRules(GameRuleStore gameRules) {
        this.gameRules = gameRules;
    }

    public void setTimeOfDay(long timeOfDay) {
        this.timeOfDay = timeOfDay;
    }

    public void setWeather(Weather weather) {
        this.weather = weather;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuntimeDimensionDescriptor)) {
            return false;
        }
        RuntimeDimensionDescriptor other = (RuntimeDimensionDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuto_load_on_server_startup() != other.isAuto_load_on_server_startup()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.isShouldTickTime() != other.isShouldTickTime()) {
            return false;
        }
        if (this.getTimeOfDay() != other.getTimeOfDay()) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$dimension_type = this.getDimension_type();
        String other$dimension_type = other.getDimension_type();
        if (this$dimension_type == null ? other$dimension_type != null : !this$dimension_type.equals(other$dimension_type)) {
            return false;
        }
        class_1267 this$difficulty = this.getDifficulty();
        class_1267 other$difficulty = other.getDifficulty();
        if (this$difficulty == null ? other$difficulty != null : !this$difficulty.equals(other$difficulty)) {
            return false;
        }
        GameRuleStore this$gameRules = this.getGameRules();
        GameRuleStore other$gameRules = other.getGameRules();
        if (this$gameRules == null ? other$gameRules != null : !this$gameRules.equals(other$gameRules)) {
            return false;
        }
        Weather this$weather = this.getWeather();
        Weather other$weather = other.getWeather();
        return !(this$weather == null ? other$weather != null : !this$weather.equals(other$weather));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuntimeDimensionDescriptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuto_load_on_server_startup() ? 79 : 97);
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + (this.isShouldTickTime() ? 79 : 97);
        long $timeOfDay = this.getTimeOfDay();
        result = result * 59 + (int)($timeOfDay >>> 32 ^ $timeOfDay);
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $dimension_type = this.getDimension_type();
        result = result * 59 + ($dimension_type == null ? 43 : $dimension_type.hashCode());
        class_1267 $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : $difficulty.hashCode());
        GameRuleStore $gameRules = this.getGameRules();
        result = result * 59 + ($gameRules == null ? 43 : $gameRules.hashCode());
        Weather $weather = this.getWeather();
        result = result * 59 + ($weather == null ? 43 : $weather.hashCode());
        return result;
    }

    public String toString() {
        return "RuntimeDimensionDescriptor(auto_load_on_server_startup=" + this.isAuto_load_on_server_startup() + ", dimension=" + this.getDimension() + ", dimension_type=" + this.getDimension_type() + ", seed=" + this.getSeed() + ", difficulty=" + String.valueOf(this.getDifficulty()) + ", gameRules=" + String.valueOf(this.getGameRules()) + ", shouldTickTime=" + this.isShouldTickTime() + ", timeOfDay=" + this.getTimeOfDay() + ", weather=" + String.valueOf(this.getWeather()) + ")";
    }

    public static class Weather {
        public int sunnyTime;
        public boolean isRaining;
        public int rainTime;
        public boolean isThundering;
        public int thunderTime;
    }
}

