/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.world.structure;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.module.initializer.world.service.WorldService;
import io.github.sakurawald.fuji.module.initializer.world.structure.RuntimeDimensionDescriptor;
import io.github.sakurawald.fuji.module.initializer.world.structure.gamerule.GameRuleStore;
import java.util.Optional;
import net.minecraft.class_1267;
import net.minecraft.class_1928;
import net.minecraft.class_27;
import net.minecraft.class_5219;
import org.jetbrains.annotations.NotNull;

public final class RuntimeDimensionProperties
extends class_27 {
    private RuntimeDimensionDescriptor runtimeDimensionDescriptor;
    private class_1928 gameRules;

    public RuntimeDimensionProperties(@NotNull class_5219 saveProperties, @NotNull RuntimeDimensionDescriptor runtimeDimensionDescriptor) {
        super(saveProperties, saveProperties.method_27859());
        this.changeRuntimeDimensionDescriptor(runtimeDimensionDescriptor);
    }

    private void applyRuntimeDimensionDescriptor() {
        this.applyGameRules();
    }

    private void applyGameRules() {
        this.gameRules = GameRuleStore.makeGameRules();
        this.getEffectiveRuntimeDimensionDescriptor().gameRules.applyTo(this.gameRules, ServerHelper.getServer());
    }

    public RuntimeDimensionDescriptor getEffectiveRuntimeDimensionDescriptor() {
        RuntimeDimensionDescriptor newRuntimeDimensionDescriptor;
        RuntimeDimensionDescriptor originalRuntimeDimensionDescriptor = this.runtimeDimensionDescriptor;
        Optional<RuntimeDimensionDescriptor> newDimensionDescriptorOptional = WorldService.getDimensionDescriptor(originalRuntimeDimensionDescriptor.dimension);
        if (newDimensionDescriptorOptional.isPresent() && originalRuntimeDimensionDescriptor != (newRuntimeDimensionDescriptor = newDimensionDescriptorOptional.get())) {
            LogUtil.info("The config for dimension {} is modified, I will apply the new config now!", originalRuntimeDimensionDescriptor.dimension);
            this.changeRuntimeDimensionDescriptor(newRuntimeDimensionDescriptor);
        }
        return this.runtimeDimensionDescriptor;
    }

    private void changeRuntimeDimensionDescriptor(RuntimeDimensionDescriptor newRuntimeDimensionDescriptor) {
        this.runtimeDimensionDescriptor = newRuntimeDimensionDescriptor;
        this.applyRuntimeDimensionDescriptor();
    }

    public class_1267 method_207() {
        return this.getEffectiveRuntimeDimensionDescriptor().difficulty;
    }

    public class_1928 method_146() {
        return this.gameRules;
    }

    public long method_188() {
        return super.method_188();
    }

    public long method_217() {
        return this.getEffectiveRuntimeDimensionDescriptor().timeOfDay;
    }

    public void method_29035(long l) {
        this.getEffectiveRuntimeDimensionDescriptor().timeOfDay = l;
    }

    public boolean method_156() {
        return this.getEffectiveRuntimeDimensionDescriptor().weather.isRaining;
    }

    public void method_157(boolean bl) {
        this.getEffectiveRuntimeDimensionDescriptor().weather.isRaining = bl;
    }

    public int method_190() {
        return this.getEffectiveRuntimeDimensionDescriptor().weather.rainTime;
    }

    public void method_164(int i) {
        this.getEffectiveRuntimeDimensionDescriptor().weather.rainTime = i;
    }

    public boolean method_203() {
        return this.getEffectiveRuntimeDimensionDescriptor().weather.isThundering;
    }

    public void method_147(boolean bl) {
        this.getEffectiveRuntimeDimensionDescriptor().weather.isThundering = bl;
    }

    public int method_145() {
        return this.getEffectiveRuntimeDimensionDescriptor().weather.thunderTime;
    }

    public void method_173(int i) {
        this.getEffectiveRuntimeDimensionDescriptor().weather.thunderTime = i;
    }

    public int method_155() {
        return this.getEffectiveRuntimeDimensionDescriptor().weather.sunnyTime;
    }

    public void method_167(int i) {
        this.getEffectiveRuntimeDimensionDescriptor().weather.sunnyTime = i;
    }
}

