/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.world.structure.gamerule;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import net.minecraft.class_1928;
import net.minecraft.class_7699;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Document(id=1752254462732L, value="This structure is used to store the `game rules`.\nIt stores both `boolean rules` and `int rules`.\n")
public final class GameRuleStore {
    public Reference2BooleanMap<class_1928.class_4313<class_1928.class_4310>> booleanRules = new Reference2BooleanOpenHashMap();
    public Reference2IntMap<class_1928.class_4313<class_1928.class_4312>> intRules = new Reference2IntOpenHashMap();

    public void setBooleanRule(class_1928.class_4313<class_1928.class_4310> key, boolean value) {
        this.booleanRules.put(key, value);
    }

    public void setIntRule(class_1928.class_4313<class_1928.class_4312> key, int value) {
        this.intRules.put(key, value);
    }

    public boolean getBooleanRule(class_1928.class_4313<class_1928.class_4310> key) {
        return this.booleanRules.getBoolean(key);
    }

    public int getIntRule(class_1928.class_4313<class_1928.class_4312> key) {
        return this.intRules.getInt(key);
    }

    public boolean containsRule(class_1928.class_4313<?> key) {
        return this.booleanRules.containsKey(key) || this.intRules.containsKey(key);
    }

    public static class_1928 makeGameRules() {
        class_1928 gameRules = new class_1928();
        return gameRules;
    }

    public static GameRuleStore makeDefault() {
        final GameRuleStore defaultGameRuleStore = new GameRuleStore();
        class_7699 enabledFeatures = ServerHelper.getServer().method_27728().method_45560();
        final class_1928 gameRules = GameRuleStore.makeGameRules();
        class_1928.method_20744((class_1928.class_4311)new class_1928.class_4311(){

            public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
                String gameRuleName = key.method_20771();
                class_1928.class_4315 gameRuleValue = gameRules.method_20746(key);
                if (gameRuleValue.getClass().equals(class_1928.class_4310.class)) {
                    class_1928.class_4313<T> typedKey = key;
                    boolean typedValue = ((class_1928.class_4310)gameRuleValue).method_20753();
                    defaultGameRuleStore.booleanRules.put(typedKey, typedValue);
                } else {
                    class_1928.class_4313<T> typedKey = key;
                    int typedValue = ((class_1928.class_4312)gameRuleValue).method_20763();
                    defaultGameRuleStore.intRules.put(typedKey, typedValue);
                }
            }
        });
        return defaultGameRuleStore;
    }

    public void applyTo(class_1928 rules, @NotNull MinecraftServer server) {
        Reference2BooleanMaps.fastForEach(this.booleanRules, entry -> {
            class_1928.class_4310 rule = (class_1928.class_4310)rules.method_20746((class_1928.class_4313)entry.getKey());
            rule.method_20758(entry.getBooleanValue(), server);
        });
        Reference2IntMaps.fastForEach(this.intRules, entry -> {
            class_1928.class_4312 rule = (class_1928.class_4312)rules.method_20746((class_1928.class_4313)entry.getKey());
            rule.method_35236(entry.getIntValue(), server);
        });
    }
}

