/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.world_downloader.structure;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.module.initializer.world_downloader.WorldDownloaderInitializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class FileDownloadHandler
implements HttpHandler {
    private static final long NANO_TO_S = 1000000000L;
    @NotNull
    private final File file;
    private final int bytesPerSecond;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(@NotNull HttpExchange exchange) {
        block20: {
            LogUtil.info("Download file: {}", this.file.getAbsolutePath());
            WorldDownloaderInitializer.safelyRemoveContext(exchange.getHttpContext().getPath());
            if ("GET".equals(exchange.getRequestMethod())) {
                if (this.file.exists() && this.file.isFile()) {
                    exchange.getResponseHeaders().set("Content-Disposition", "attachment; filename=" + this.file.getName());
                    exchange.getResponseHeaders().set("Content-Type", "application/octet-stream");
                    long fileLength = this.file.length();
                    exchange.sendResponseHeaders(200, fileLength);
                    OutputStream os = exchange.getResponseBody();
                    try {
                        FileInputStream fis = new FileInputStream(this.file);
                        try {
                            int bytesRead;
                            byte[] buffer = new byte[1024];
                            long startTime = System.nanoTime();
                            long bytesReadCount = 0L;
                            while ((bytesRead = fis.read(buffer)) != -1) {
                                long currentTime = System.nanoTime();
                                long elapsedTime = currentTime - startTime;
                                long bytesReadExpected = elapsedTime * (long)this.bytesPerSecond / 1000000000L;
                                if (bytesReadCount + (long)bytesRead > bytesReadExpected) {
                                    try {
                                        long sleepTime = (bytesReadCount + (long)bytesRead - bytesReadExpected) * 1000000000L / (long)this.bytesPerSecond;
                                        Thread.sleep(TimeUnit.NANOSECONDS.toMillis(sleepTime));
                                    }
                                    catch (InterruptedException e) {
                                        LogUtil.warn("Interrupted while sleeping for throttling", e);
                                        if (Collections.singletonList(fis).get(0) != null) {
                                            fis.close();
                                        }
                                        if (Collections.singletonList(os).get(0) != null) {
                                            os.close();
                                        }
                                        return;
                                    }
                                }
                                os.write(buffer, 0, bytesRead);
                                bytesReadCount += (long)bytesRead;
                            }
                            break block20;
                        }
                        finally {
                            if (Collections.singletonList(fis).get(0) != null) {
                                fis.close();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(os).get(0) != null) {
                            os.close();
                        }
                    }
                }
                String response = "File not found.";
                exchange.sendResponseHeaders(404, response.length());
                OutputStream os = exchange.getResponseBody();
                os.write(response.getBytes());
            }
        }
        LogUtil.info("Delete file: {} (success: {})", this.file.getAbsolutePath(), this.file.delete());
    }

    public FileDownloadHandler(@NotNull File file, int bytesPerSecond) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.file = file;
        this.bytesPerSecond = bytesPerSecond;
    }
}

