/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.mixin.command_interactive;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.module.initializer.command_interactive.CommandInteractiveInitializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2478;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_8242;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2478.class})
public class AbstractSignBlockMixin {
    @Unique
    private static final String COMMAND_STRING_SPLIT_CHARACTER = "/";

    @Inject(method={"onUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void listenSignBlockUse(class_2680 blockState, class_1937 world, class_2338 blockPos, class_1657 player, class_1268 hand, class_3965 blockHitResult, CallbackInfoReturnable<class_1269> cir) {
        class_2625 signBlockEntity;
        class_8242 facingSignText;
        String facingSignLines;
        if (AbstractSignBlockMixin.canUseInteractiveCommand(player)) {
            return;
        }
        if (!PlayerHelper.isServerPlayer(player)) {
            return;
        }
        class_2586 interactingBlockEntity = world.method_8321(blockPos);
        if (interactingBlockEntity instanceof class_2625 && (facingSignLines = this.extractSignLines(facingSignText = (signBlockEntity = (class_2625)interactingBlockEntity).method_49843(signBlockEntity.method_49834(player)))).contains(COMMAND_STRING_SPLIT_CHARACTER)) {
            cir.setReturnValue((Object)class_1269.field_21466);
            List<String> commands = this.splitCommands(facingSignLines).stream().map(str -> TextHelper.Parsers.parsePlaceholderString(player, str)).toList();
            commands.forEach(commandString -> CommandInteractiveInitializer.mimicCommandExecutionPacket((class_3222)player, commandString));
        }
    }

    @Unique
    private static boolean canUseInteractiveCommand(class_1657 player) {
        return player.method_5715();
    }

    @Unique
    @NotNull
    public String extractSignLines(@NotNull class_8242 signText) {
        return Arrays.stream(signText.method_49877(false)).map(class_2561::getString).reduce("", String::concat);
    }

    @Unique
    @NotNull
    public List<String> splitCommands(@NotNull String text) {
        int left = text.indexOf(COMMAND_STRING_SPLIT_CHARACTER);
        text = text.substring(left + 1);
        String[] split = text.split(COMMAND_STRING_SPLIT_CHARACTER);
        return Arrays.stream(split).map(String::trim).collect(Collectors.toCollection(ArrayList::new));
    }
}

