/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.mixin.command_permission;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.module.initializer.command_permission.CommandPermissionInitializer;
import io.github.sakurawald.fuji.module.initializer.command_permission.structure.WrappedPredicate;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={CommandNode.class}, remap=false)
public class CommandNodeMixin {
    @Unique
    private final CommandNode<class_2168> node = (CommandNode)this;
    @Mutable
    @Shadow
    @Final
    private Predicate<class_2168> requirement;

    @ModifyReturnValue(method={"getRequirement"}, at={@At(value="TAIL")})
    private Predicate<?> wrapRequirementPredicateForThisCommandNode(Predicate<?> original) {
        @Nullable CommandDispatcher<class_2168> dispatcher = ServerHelper.getCommandDispatcher();
        if (dispatcher == null) {
            LogUtil.debug("The CommandNode#getRequirement is triggered too early, fuji will just ignore this call.", new Object[0]);
            return original;
        }
        if (!(original instanceof WrappedPredicate)) {
            String path = CommandHelper.findCommandNodePath(this.node);
            this.requirement = CommandPermissionInitializer.makeWrappedPredicate(path, original);
            return this.requirement;
        }
        return original;
    }
}

