/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.command.argument.adapter.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import mod.fuji.core.auxiliary.minecraft.AuthlibHelper;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import mod.fuji.core.command.argument.structure.CommandArgument;
import mod.fuji.core.command.argument.wrapper.impl.OfflinePlayerName;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

public class OfflinePlayerNameArgumentTypeAdapter
extends BaseArgumentTypeAdapter {
    @Override
    public ArgumentType<?> makeArgumentType() {
        return StringArgumentType.string();
    }

    @Override
    @NotNull
    protected RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(@NotNull String argumentName) {
        return super.makeRequiredArgumentBuilder(argumentName).suggests(CommandHelper.Suggestion.iterable(PlayerHelper.Cache::getOfflinePlayerNames));
    }

    @Override
    public Object makeArgumentValue(@NotNull CommandContext<class_2168> context, @NotNull CommandArgument commandArgument) {
        String offlinePlayerName = StringArgumentType.getString(context, (String)commandArgument.getArgumentName());
        return PlayerHelper.Cache.getOfflineGameProfileByName(offlinePlayerName).map($gameProfile -> new OfflinePlayerName(AuthlibHelper.getName($gameProfile))).orElseThrow(() -> {
            TextHelper.sendTextByKey(context.getSource(), "player.unknown_player", new Object[0]);
            return new AbortCommandExecutionException();
        });
    }

    @Override
    public List<Class<?>> getTypeClasses() {
        return List.of(OfflinePlayerName.class);
    }

    @Override
    public List<String> getTypeNames() {
        return List.of("offline-player");
    }
}

