/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_advice;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.StringUtil;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.document.annotation.TestCases;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.command.CommandExecutionPostEvent;
import mod.fuji.core.event.message.command.CommandExecutionPreEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.command_advice.config.model.CommandAdviceConfigModel;
import mod.fuji.module.initializer.command_advice.config.transformer.CommandAdviceV1SchemaTransformer;
import mod.fuji.module.initializer.command_advice.config.transformer.CommandAdviceV2SchemaTransformer;
import mod.fuji.module.initializer.command_advice.structure.CommandAdviceEntry;
import mod.fuji.module.initializer.command_advice.structure.CommandAdviceType;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Document(id=1751826306321L, value="This module allows defining `advices` to decorate `an existing target command`.\n\nThe command `advice types` include:\n- `BEFORE_EXECUTION`\n- `AFTER_EXECUTION`\n- `ON_EXECUTION_SUCCESS`\n- `ON_EXECUTION_FAILURE`\n- `ON_EXECUTION_CANCELLED`\n- `CANCEL_AS_SUCCESS`\n- `CANCEL_AS_FAILURE`\n- `CANCEL_IF_ANY_SUCCESS`\n- `CANCEL_IF_ALL_SUCCESS`\n- ...\n")
@ColorBoxes(value={@ColorBox(id=1756196951881L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Compare between `command_advice` and `command_bundle` module.\nThe `command_advice` module is used to `decorate` an `existing target command`.\nThe `command_bundle` module is used to `create` a `new command`.\n"), @ColorBox(id=1756197023849L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Semantics of each `advice type`.\n- `BEFORE_EXECUTION`: Run specified commands `before` the execution of target command (If it's not `cancelled` by other advices).\n- `AFTER_EXECUTION`: Run specified commands `after` the execution of target command (Regardless of whether it's `SUCCESS` or `FAILURE`).\n- `ON_EXECUTION_SUCCESS`: Run specified commands `if` the execution of target command is `SUCCESS` (Return value > 0).\n- `ON_EXECUTION_FAILURE`: Run specified commands `if` the execution of target command is `FAILURE` (Return value = 0).\n- `ON_EXECUTION_CANCELLED`: Run specified commands `if` the execution of target command is `CANCELLED` by other advices.\n- `CANCEL_AS_SUCCESS`: Cancel the execution of target command, and treat it as `SUCCESS` (Return value = 1).\n- `CANCEL_AS_FAILURE`: Cancel the execution of target command, and treat it as `FAILURE` (Return value = 0).\n- `CANCEL_IF_ANY_SUCCESS`: If `ANY specified command is SUCCESS`, then cancel the execution of target command, and treat it as `FAILURE` (Return value = 0).\n- `CANCEL_IF_ALL_SUCCESS`: If `ALL specified commands are SUCCESS`, then cancel the execution of target command, and treat it as `FAILURE` (Return value = 0).\n"), @ColorBox(id=1756198153881L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 `Decorate` an existing target command.\nSee the example for `/heal` command in default config.\n\n\u25c9 `Cancel` the execution of target command, and execute specified commands instead.\nSee the example for `/say` command in default config.\n\n\u25c9 Ensure that the target command executes only when the specified `conditions` are met, and apply the `cost` if the execution succeeds.\nSee the example for `/repair` command in default config:\n1. Use `CANCEL_IF_ANY_SUCCESS` advice type, to check the `conditions`.\n2. Use `ON_EXECUTION_CANCELLED` advice type, to send `feedback` if conditions are not met.\n3. Use `ON_EXECUTION_SUCCESS` advice type, to apply the `cost` for the execution of target command.\n")})
public class CommandAdviceInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<CommandAdviceConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", CommandAdviceConfigModel.class).installTransformer(new CommandAdviceV1SchemaTransformer()).installTransformer(new CommandAdviceV2SchemaTransformer());

    @TestCases(value={@TestCase(action="Test the basic use-case of command advice.", targets={"Issue `/heal` command, you should see the heart particle.", "Issue `/say Hello World` command, you should see the replaced version.", "Issue `/msg @s Ping` command, you should see the replaced version."}), @TestCase(action="Test the advanced use-case of command advice.", targets={"Issue `/repair` with `iron_ingot x 8`, `gold_ingot x 16` and `damaged diamond sword`.", "Issue `/repair` with `iron_ingot x 16`, `gold_ingot x 16` and `non-damaged diamond sword`.", "Issue `/repair` with `iron_ingot x 16`, `gold_ingot x 16` and `damaged diamond sword`."})})
    private static void processCommandAdvice(@NotNull Object executor, @NotNull class_2168 source, @NotNull String commandString, @NotNull CommandAdviceType adviceType, @NotNull Optional<CallbackInfo> callbackInfo, @NotNull Optional<Integer> targetCommandReturnValue) {
        LogUtil.debug("Process Command Advice: advice type = {}, command string = {}, command source = {}, executor = {}, target command return value = {}", new Object[]{adviceType, commandString, source.method_9214(), executor, targetCommandReturnValue});
        Stream<Object> filterCommandAdvices = config.model().getAdvices().stream();
        filterCommandAdvices = filterCommandAdvices.filter(CommandAdviceEntry::isEnable);
        filterCommandAdvices = filterCommandAdvices.filter(it -> it.getAdviceType().equals((Object)adviceType) || it.getAdviceType().isCanceller() && adviceType.equals((Object)CommandAdviceType.BEFORE_EXECUTION) || it.getAdviceType().equals((Object)CommandAdviceType.ON_EXECUTION_CANCELLED) && adviceType.equals((Object)CommandAdviceType.BEFORE_EXECUTION));
        filterCommandAdvices = filterCommandAdvices.filter(it -> it.getMatcher().isAcceptPlayerCommandSource() && CommandHelper.Source.isExecutedByPlayer(source) || it.getMatcher().isAcceptConsoleCommandSource() && CommandHelper.Source.isExecutedByConsole(source));
        filterCommandAdvices = filterCommandAdvices.filter(it -> commandString.matches(it.getMatcher().getCommandStringRegex()));
        List<Object> effectiveCommandAdvices = filterCommandAdvices.toList();
        AtomicBoolean targetCommandExecutionCancelled = new AtomicBoolean(false);
        effectiveCommandAdvices.stream().filter(it -> it.getAdviceType().isCanceller()).forEach(it -> {
            if (targetCommandExecutionCancelled.get()) {
                return;
            }
            @NotNull List<Integer> adviceCommandReturnValues = CommandAdviceInitializer.executeAdviceCommands(source, commandString, it);
            if (it.getAdviceType().equals((Object)CommandAdviceType.CANCEL_IF_ANY_SUCCESS)) {
                if (adviceCommandReturnValues.stream().anyMatch(CommandHelper.Return::isSuccess)) {
                    CommandAdviceInitializer.cancelTargetCommandExecution(commandString, it, targetCommandExecutionCancelled, callbackInfo);
                }
            } else if (it.getAdviceType().equals((Object)CommandAdviceType.CANCEL_IF_ALL_SUCCESS)) {
                if (adviceCommandReturnValues.stream().allMatch(CommandHelper.Return::isSuccess)) {
                    CommandAdviceInitializer.cancelTargetCommandExecution(commandString, it, targetCommandExecutionCancelled, callbackInfo);
                }
            } else {
                CommandAdviceInitializer.cancelTargetCommandExecution(commandString, it, targetCommandExecutionCancelled, callbackInfo);
            }
        });
        if (targetCommandExecutionCancelled.get()) {
            effectiveCommandAdvices.stream().filter(it -> it.getAdviceType().equals((Object)CommandAdviceType.ON_EXECUTION_CANCELLED)).forEach(it -> CommandAdviceInitializer.executeAdviceCommands(source, commandString, it));
            return;
        }
        effectiveCommandAdvices.stream().filter(it -> !it.getAdviceType().isCanceller() && !it.getAdviceType().equals((Object)CommandAdviceType.ON_EXECUTION_CANCELLED)).forEach(it -> {
            if (it.getAdviceType().equals((Object)CommandAdviceType.BEFORE_EXECUTION) || it.getAdviceType().equals((Object)CommandAdviceType.AFTER_EXECUTION)) {
                CommandAdviceInitializer.executeAdviceCommands(source, commandString, it);
            } else if (it.getAdviceType().equals((Object)CommandAdviceType.ON_EXECUTION_SUCCESS) || it.getAdviceType().equals((Object)CommandAdviceType.ON_EXECUTION_FAILURE)) {
                targetCommandReturnValue.ifPresentOrElse($targetCommandReturnValue -> {
                    boolean success = CommandHelper.Return.isSuccess($targetCommandReturnValue);
                    if (it.getAdviceType().equals((Object)CommandAdviceType.ON_EXECUTION_SUCCESS) && success) {
                        CommandAdviceInitializer.executeAdviceCommands(source, commandString, it);
                        return;
                    }
                    if (it.getAdviceType().equals((Object)CommandAdviceType.ON_EXECUTION_FAILURE) && !success) {
                        CommandAdviceInitializer.executeAdviceCommands(source, commandString, it);
                        return;
                    }
                }, () -> LogUtil.debug("The return value of target command {} is null, can't perform the command advice {}.", commandString, it));
            }
        });
    }

    private static void cancelTargetCommandExecution(@NotNull String commandString, @NotNull CommandAdviceEntry commandAdvice, @NotNull AtomicBoolean targetCommandExecutionCancelled, @NotNull Optional<CallbackInfo> callbackInfo) {
        targetCommandExecutionCancelled.set(true);
        callbackInfo.ifPresentOrElse($callbackInfo -> {
            LogUtil.debug("Cancel the executing of target command {}. (advice = {})", commandString, commandAdvice);
            if ($callbackInfo instanceof CallbackInfoReturnable) {
                ((CallbackInfoReturnable)$callbackInfo).setReturnValue((Object)commandAdvice.getAdviceType().getAlternativeReturnValue());
            } else {
                $callbackInfo.cancel();
            }
        }, () -> LogUtil.warn("Failed to cancel the execution of target command {}, due to the Optional<CallbackInfo> is empty. (advice = {})", commandString, commandAdvice));
    }

    @NotNull
    private static List<Integer> executeAdviceCommands(@NotNull class_2168 source, @NotNull String commandString, @NotNull CommandAdviceEntry commandAdvice) {
        Matcher matcher = commandAdvice.getMatcher().getCachedPattern().matcher(commandString);
        matcher.find();
        List commands = commandAdvice.getCommands().stream().map(cmd -> StringUtil.replaceAllAndResetMatcher(matcher, cmd)).collect(Collectors.toCollection(ArrayList::new));
        LogUtil.debug("Execute advices commands {}. (advice = {})", commands, commandAdvice);
        List<Integer> adviceCommandReturnValues = CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(source), commands);
        LogUtil.debug("Get advice command return values {}. (advice = {})", adviceCommandReturnValues, commandAdvice);
        return adviceCommandReturnValues;
    }

    @EventConsumer(injectorPriority=2000, consumerPriority=2000)
    private static void consumeBeforeCommandExecutionEvent(CommandExecutionPreEvent event) {
        if (event.getCallback().isCancelled()) {
            return;
        }
        CommandAdviceInitializer.processCommandAdvice(event.getCommandExecutor(), event.getCommandSource(), event.getCommandString(), CommandAdviceType.BEFORE_EXECUTION, Optional.of(event.getCallback()), event.getCommandReturnValue());
    }

    @EventConsumer(injectorPriority=2000, consumerPriority=2000)
    private static void consumeAfterCommandExecutionEvent(CommandExecutionPostEvent event) {
        event.getCommandReturnValue().ifPresent(commandReturnValue -> {
            boolean logicalSuccess = CommandHelper.Return.isSuccess(commandReturnValue);
            CommandAdviceType adviceType = logicalSuccess ? CommandAdviceType.ON_EXECUTION_SUCCESS : CommandAdviceType.ON_EXECUTION_FAILURE;
            CommandAdviceInitializer.processCommandAdvice(event.getCommandExecutor(), event.getCommandSource(), event.getCommandString(), adviceType, event.getCallback(), event.getCommandReturnValue());
        });
        CommandAdviceInitializer.processCommandAdvice(event.getCommandExecutor(), event.getCommandSource(), event.getCommandString(), CommandAdviceType.AFTER_EXECUTION, event.getCallback(), event.getCommandReturnValue());
    }
}

