/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_event;

import java.util.List;
import java.util.Optional;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerDeathEvent;
import mod.fuji.core.event.message.player.PlayerJoinedEvent;
import mod.fuji.core.event.message.player.PlayerLeftEvent;
import mod.fuji.core.event.message.player.PlayerWorldChangedEvent;
import mod.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import mod.fuji.core.event.message.server.lifecycle.ServerStoppingEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.command_event.config.model.CommandEventConfigModel;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Document(id=1751826634816L, value="This module allows executing `defined commands` in response to various `events`.\n")
@ColorBoxes(value={@ColorBox(id=1751904334639L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\nWhen an interested event occurs, this module will execute specified commands for that event as console.\nThe `contextual player` in that `event` will be used as the `placeholder context`, to parse the `placeholders` in the `command string`.\n"), @ColorBox(id=1751904417278L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Send messages on player join.\nYou can use `/send-custom` or `/send-message` to send messages when a player joins.\n\n\u25c9 Execute commands to welcome a new player.\nYou can use the player first join event.\nFor example:\n1. `send-broadcast \\<light_purple\\>Welcome new player %player:name% to join us!`\n2. `kit give %player:name% \\<kit-name\\>`\n3. `send-custom as-message %player:name% new-player-guide`\n4. `run as fake-op %player:name% rtp`\n5. `delay 10 spawnpoint %player:name%\"`\n"), @ColorBox(id=1758083275998L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Teleport the dead player to specified position.\nYOu can use the player death event.\n1. `run as fake-op %player:name% tppos --dimension minecraft:overworld --x 32 --y 64 --z 128`\n")})
public class CommandEventInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandEventConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", CommandEventConfigModel.class);

    public static void executeCommandOnEvent(@Nullable class_3222 player, @NotNull List<String> commands) {
        class_2168 commandSource = Optional.ofNullable(player).map($player -> player.method_5671()).orElseGet(CommandHelper.Source::getConsoleCommandSource);
        CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(commandSource), commands);
    }

    @EventConsumer
    private static void consumePlayerJoinedEvent(PlayerJoinedEvent event) {
        int stat;
        CommandEventConfigModel.Event.OnPlayerFirstJoined onPlayerFirstJoinedConfig;
        class_3222 player = event.getPlayer();
        CommandEventConfigModel.Event.OnPlayerJoined onPlayerJoinedConfig = config.model().getEvent().getOnPlayerJoined();
        if (onPlayerJoinedConfig.isEnable()) {
            CommandEventInitializer.executeCommandOnEvent(player, onPlayerJoinedConfig.getCommands());
        }
        if ((onPlayerFirstJoinedConfig = config.model().getEvent().getOnPlayerFirstJoined()).isEnable() && (stat = player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_33558))) == 0) {
            CommandEventInitializer.executeCommandOnEvent(player, onPlayerFirstJoinedConfig.getCommands());
        }
    }

    @EventConsumer
    private static void consumePlayerLeftEvent(PlayerLeftEvent event) {
        CommandEventConfigModel.Event.OnPlayerLeft config = CommandEventInitializer.config.model().getEvent().getOnPlayerLeft();
        if (config.isEnable()) {
            CommandEventInitializer.executeCommandOnEvent(event.getPlayer(), config.getCommands());
        }
    }

    @EventConsumer
    private static void consumePlayerDeathEvent(PlayerDeathEvent event) {
        CommandEventConfigModel.Event.OnPlayerDeath config = CommandEventInitializer.config.model().getEvent().getOnPlayerDeath();
        if (config.isEnable()) {
            class_3222 player = event.getPlayer();
            CommandEventInitializer.executeCommandOnEvent(player, config.getCommands());
        }
    }

    @EventConsumer
    private static void consumePlayerWorldChangedEvent(PlayerWorldChangedEvent event) {
        CommandEventConfigModel.Event.AfterPlayerChangeWorld config = CommandEventInitializer.config.model().getEvent().getAfterPlayerChangeWorld();
        if (config.isEnable()) {
            CommandEventInitializer.executeCommandOnEvent(event.getPlayer(), config.getCommands());
        }
    }

    @EventConsumer
    private static void consumeOnServerStartedEvent(@Unused ServerStartedEvent event) {
        CommandEventConfigModel.Event.OnServerStarted config = CommandEventInitializer.config.model().getEvent().getOnServerStarted();
        if (config.isEnable()) {
            CommandEventInitializer.executeCommandOnEvent(null, config.getCommands());
        }
    }

    @EventConsumer
    private static void consumeOnServerStoppingEvent(@Unused ServerStoppingEvent event) {
        CommandEventConfigModel.Event.OnServerStopping config = CommandEventInitializer.config.model().getEvent().getOnServerStopping();
        if (config.isEnable()) {
            CommandEventInitializer.executeCommandOnEvent(null, config.getCommands());
        }
    }
}

