/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_permission;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.argument.wrapper.impl.GreedyCommandString;
import mod.fuji.core.command.structure.CommandNodeWithPath;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.Cite;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.document.descriptor.PermissionDescriptor;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.server.command.CommandRegistrationEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.command_permission.config.model.CommandPermissionConfigModel;
import mod.fuji.module.initializer.command_permission.gui.CommandPermissionGui;
import mod.fuji.module.initializer.command_permission.service.CommandPermissionService;
import mod.fuji.module.initializer.command_permission.structure.CommandNodePermissionWrapper;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

@Cite(value={"https://github.com/DrexHD/VanillaPermissions"})
@Document(id=1751826772214L, value="This module provides the `luckperms permissions` for `all commands`.\nThe `target command` can be a command from the `vanilla Minecraft`, or any other `mods`.\n")
@ColorBoxes(value={@ColorBox(id=1751970566759L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\nThe vanilla Minecraft use a command system, named `brigadier command system`.\nAll `commands` are `registered`, `parsed` and `executed` by this system.\nIn the design of this command system, all commands are built into a `tree structure`.\nThat is the `command tree`.\nAll commands starts with the `root command`, and walking down the `path` of the `command tree`.\nAll commands are a `direct child` or `in-direct child` of the `root command node`.\nBased on these facts, we can `identify` a `command node` using its `path` in the `command tree`.\n\nFor example, the command string `/gamemode creative Steve`.\nCan be parsed into command nodes: `gamemode`, `creative` and `Steve`.\nAnd its `command path` is `gamemode.gamemode.target`.\n\nYou can issue `/command-permission describe gamemode creative Steve` to see what is happening.\nTo see the `tree structure` of this command node, issue `/help gamemode` command.\n\nTo open the command permission GUI, issue `/command-permission gui` command.\nTo list all commands and their command path, issue `/fuji inspect server-commands` command.\n"), @ColorBox(id=1751970931219L, color=ColorBox.ColorBoxTypes.NOTE, value="Let's continue, the `brigadier command system`, organize all `command nodes` into a `tree structure`.\nAnd for each `command node`, there is a `requirement` option, it's a `predicate`, to decide whether the `command source` can use this `command node`.\n\nThat's the core part.\nThe `command_permission` module, will walk down the entire `command tree`.\nAnd `wrap` the `requirement` option for each `command node`.\nAnd then, we can assign a `luckperms permission` for each `command node`.\nThat's because, we can `identify` a `command node` using its `command path` in the `command tree`.\n\nIssue: `/command-permission describe gamemode creative Steve` to see how it works.\n"), @ColorBox(id=1751971202478L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How does `command_permission` module handles the `inheritance permission`, `wildcard permission` and `regex permission`?\n\nActually, the `command_permission` module didn't handle them.\nThe module only does one simple thing: Let's check if the command source has the corresponding luckperms permission `fuji.permission.\\<command path of that target command\\>`.\nThe complex things like `inheritance permission`, `wildcard permission` and `regex permission` are all processed by `luckperms` mod.\nYeah, the `luckperms` mod does the complex `permission calculation`.\n"), @ColorBox(id=1756284897212L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Advanced universal permission mod.\nThe `command_permission` module was originally inspired by the `Vanilla Permissions` mod.\nIf you want advanced features, check `Vanilla Permissions` mod.\n"), @ColorBox(id=1751971384898L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Allow everyone to use `/gamemode` command.\nYou can issue `/lp group default permission set fuji.permission.gamemode true`\n\nNOTE: If you want to allow the client-side to use the gamemode switcher menu, you have to install extra mods in the client-side, to let the client-side believe they are `op`, and they can switch the gamemode.\nThe mod can be https://modrinth.com/mod/switcher\n"), @ColorBox(id=1751971538425L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Allow everyone to use `/gamemode` command, except the player Alice.\nIssue the commands:\n1. `/lp group default permission set fuji.permission.gamemode true`\n2. `/lp user Alice permission set fuji.permission.gamemode false`\n"), @ColorBox(id=1751971597924L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Allow everyone to use `/gamemode spectator`, but disallows the `/gamemode creative`.\nYou have touch the core, and the tricky things.\nNow, issue `/command-permission describe gamemode spectator` command.\nYou will find that, the second command node `creative` is actually `an argument`.\nIts `argument` whose argument type is `gamemode`, and accepts the possible values `adventure`, `creative`, `spectator` and `survival`.\nAll 4 gamemodes are possible values for `gamemode argument type`.\nThat's the reason why you can't just ban the `creative` gamemode.\n\nIf you really want to allow the user to use `/gamemode spectator`, and ban the `/gamemode creative`.\nYou can use `command_bundle` to create a `user-level` command, to wrap the `/gamemode` command.\nLike, create a new command named `/switch-to-survival`, as a wrapper command for `/gamemode` command.\n"), @ColorBox(id=1751990106002L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Allow players to use `/seed` command.\nThe `/seed` command provided by Mojang, requires `level permission` to be `3` to use.\nIf you want to `allow` players to use `/seed` command, but you don't want to grant `op` for them.\nThen, you can `set` a `positive string permission` for them.\nIssue `/lp group default permission set fuji.permission.seed true`.\nIt says `allow` the players to use `/seed` command.\n\nIssue `/command-permission describe seed` command, to see how it works.\n"), @ColorBox(id=1751990203999L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Dis-allow players to use `/list` command.\nThe `/list` command provided by Mojang, requires `level permission` to be `0` to use.\nIf you want to `dis-allow` players to use `/list` command.\nBut because this command requires no string permission to use.\nSo it's impossible to ban it via `luckperms` mod.\n\nIn this case, you `can` set a `negative string permission` for them.\nIssue `/lp group default permission set fuji.permission.list false`.\nIt says `dis-allow` the players to use `/list` command.\n\nIssue `/command-permission describe list` command, to see how it works.\n"), @ColorBox(id=1751990343803L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Unset the override of requirement of a specific command.\nTo `undo` the operation in the `/seed` example.\nYou can `unset` the assigned permission before.\nIssue `/lp group default permission unset fuji.permission.seed` command, to unset the assign permission.\n"), @ColorBox(id=1751990466823L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Advanced Usage\nThe `luckperms` mod have a feature named `permission context`.\nWhich allows you to specify the `per-dimension permission` and `temporary permission`.\nIf you are interested, see the details in their official wiki.\n")})
@mod.fuji.core.command.annotation.CommandNode(value="command-permission")
@CommandRequirement(level=4)
public class CommandPermissionInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandPermissionConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", CommandPermissionConfigModel.class);
    @DocStringProvider(id=1752000303860L, value="To use the `command` with that `command path`.\nYou need the corresponding permission.\n\nIssue `/command-permission describe` to see details.\n1. `/command-permission describe fly`\n2. `/command-permission describe fly others @r`\n")
    public static final PermissionDescriptor COMMAND_PERMISSION_UNIFIED_PERMISSION = new PermissionDescriptor("fuji.permission.<command-path>", 1752000303860L);

    @mod.fuji.core.command.annotation.CommandNode(value="gui")
    @Document(id=1751826777672L, value="Open the command permission gui.")
    public static int $gui(@CommandSource class_3222 player) {
        List<CommandNodePermissionWrapper> entities = CommandHelper.Tree.getAllCommandNodes().stream().map(CommandNodePermissionWrapper::new).sorted(Comparator.comparing(CommandNodeWithPath::getPath)).toList();
        new CommandPermissionGui(player, entities, 0).open();
        return 1;
    }

    @Document(id=1751826779531L, value="Toggle the command permission verbose mode.")
    @mod.fuji.core.command.annotation.CommandNode(value="verbose")
    public static int $verbose(@CommandSource class_2168 source) {
        CommandPermissionService.verboseModeFlag = !CommandPermissionService.verboseModeFlag;
        TextHelper.sendTextByKey(source, CommandPermissionService.verboseModeFlag ? "command_permission.verbose.on" : "command_permission.verbose.off", new Object[0]);
        return 1;
    }

    @Document(id=1751826781243L, value="Describe the `required permissions` of `the given command`.")
    @mod.fuji.core.command.annotation.CommandNode(value="describe")
    public static int $describe(@CommandSource class_2168 source, GreedyCommandString command) {
        String $command = (String)command.getValue();
        ParseResults parseResults = CommandHelper.getCommandDispatcher().parse($command, (Object)source);
        CommandContextBuilder context = parseResults.getContext();
        String commandString = TextHelper.Parsers.escapeTags(parseResults.getReader().getString());
        TextHelper.sendTextByKey(source, "command_permission.describe.command_string", commandString);
        @Nullable CommandSyntaxException earlyException = class_2170.method_23917((ParseResults)parseResults);
        if (earlyException != null) {
            TextHelper.sendTextByKey(source, "command_permission.describe.command_string.parser.exceptions", new Object[0]);
            TextHelper.sendTextByKey(source, "command_permission.describe.command_string.parser.early_exception", new Object[]{earlyException});
            return 1;
        }
        Map exceptions = parseResults.getExceptions();
        if (!exceptions.isEmpty()) {
            TextHelper.sendTextByKey(source, "command_permission.describe.command_string.parser.exceptions", new Object[0]);
            exceptions.forEach((k, v) -> {
                String nodeName = k.getName();
                String exception = v.toString();
                TextHelper.sendTextByKey(source, "command_permission.describe.command_string.parser.exception", nodeName, exception);
            });
            return 1;
        }
        List nodes = context.getNodes();
        List<String> nodesName = nodes.stream().map(it -> it.getNode().getName()).toList();
        TextHelper.sendTextByKey(source, "command_permission.describe.command_node.nodes", nodesName);
        if (nodesName.isEmpty()) {
            TextHelper.sendTextByKey(source, "command_permission.describe.command_node.empty", new Object[0]);
            return 1;
        }
        nodes.forEach(it -> {
            CommandNode node = it.getNode();
            String nodeName = node.getName();
            String nodeType = CommandHelper.Node.toCommandNodeTypeString((CommandNode<class_2168>)node);
            boolean nodeWrapped = CommandPermissionService.isCommandNodeWrapped((CommandNode<class_2168>)node);
            TextHelper.sendTextByKey(source, "command_permission.describe.command_node.node", nodeName, nodeType, nodeWrapped);
        });
        String commandPath = CommandHelper.Path.toLinearCommandPathString(context.getNodes().stream().map(ParsedCommandNode::getNode).toList());
        TextHelper.sendTextByKey(source, "command_permission.describe.command_path", commandPath);
        TextHelper.sendTextByKey(source, "command_permission.describe.command_permissions", new Object[0]);
        List<String> commandPathPrefixes = CommandHelper.Path.getPrefixesOfCommandPath(nodes);
        commandPathPrefixes.forEach(path -> {
            String requiredPermission = COMMAND_PERMISSION_UNIFIED_PERMISSION.withArguments(path);
            TextHelper.sendTextByKey(source, "command_permission.describe.command_permission", requiredPermission);
        });
        TextHelper.sendMessageByText(source, (class_2561)class_2561.method_43473());
        return 1;
    }

    @EventConsumer(injectorPriority=2000, consumerPriority=1001)
    @TestCase(action="Issue `/reload` command, and check the client command tree.", targets={"The `command_permission` module should warp the newly registered commands.", "The client-side command tree should be updated."})
    private static void ensureAllCommandNodesAreWrapped(@Unused CommandRegistrationEvent event) {
        CommandPermissionService.ensureCommandNodeRequirementIsWrapped();
    }
}

