/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_toolbox.warp.service;

import java.util.List;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.core.structure.GlobalPos;
import mod.fuji.module.initializer.command_toolbox.warp.WarpInitializer;
import mod.fuji.module.initializer.command_toolbox.warp.structure.WarpDescriptor;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarpService {
    public static Optional<WarpDescriptor> findWarp(@NotNull String warpId) {
        return Optional.ofNullable(WarpInitializer.data.model().warps.get(warpId)).map(value -> {
            value.setKey(warpId);
            return value;
        });
    }

    public static void doWarp(@NotNull WarpDescriptor warpDescriptor, @NotNull class_3222 player) {
        warpDescriptor.getPosition().teleport(player);
        ExtendedCommandSource extendedCommandSource = ExtendedCommandSource.asConsole(player.method_5671());
        List<String> commandList = warpDescriptor.getEvent().getOnWarped().getCommandList();
        CommandExecutor.executeBatch(extendedCommandSource, commandList);
        TextHelper.sendTextByKey(player, "warp.tp.success", warpDescriptor.getDisplayName());
    }

    @NotNull
    public static Optional<WarpDescriptor> deleteWarp(@NotNull WarpDescriptor warpDescriptor) {
        String id = warpDescriptor.getKey();
        @Nullable WarpDescriptor previousValue = WarpInitializer.data.model().warps.remove(id);
        return Optional.ofNullable(previousValue);
    }

    @NotNull
    public static List<WarpDescriptor> listWarps() {
        return WarpInitializer.data.model().warps.values().stream().toList();
    }

    @NotNull
    public static List<String> listWarpIds() {
        return WarpInitializer.data.model().warps.keySet().stream().toList();
    }

    public static void createWarp(@NotNull class_3222 player, @NotNull String warpId) {
        WarpDescriptor newValue = new WarpDescriptor(GlobalPos.of(player)).withDisplayName(warpId);
        WarpInitializer.data.model().warps.put(warpId, newValue);
    }
}

