/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary;

import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import mod.fuji.core.config.Configs;
import mod.fuji.core.config.model.MainControlConfigModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LogUtil {
    @NotNull
    private static final Logger MOD_LOGGER = LogUtil.makeLogger(StringUtils.capitalize((String)"fuji"));
    private static final boolean IS_CONSOLE_SUPPORTS_ANSI_COLOR = LogUtil.isConsoleSupportAnsiColor();

    @NotNull
    private static Logger makeLogger(String name) {
        return LogManager.getLogger((String)name);
    }

    private static boolean isConsoleSupportAnsiColor() {
        return ServerHelper.Environment.isServerSideDedicatedServer();
    }

    private static String attachSourceModulePrefix(String message) {
        String prefix = "[%s] ".formatted(ReflectionUtil.Stacktrace.findSourceModuleInCurrentStackTrace());
        return prefix + message;
    }

    public static void debug(String message, Object ... args) {
        MainControlConfigModel.Core.Debug debugConfig = Configs.MAIN_CONTROL_CONFIG.model().core.debug;
        if (!debugConfig.log_debug_messages) {
            return;
        }
        message = LogUtil.attachSourceModulePrefix((String)message);
        if (debugConfig.log_debug_messages) {
            String ansiColorPrefix = IS_CONSOLE_SUPPORTS_ANSI_COLOR ? "\u001b[37m" : "";
            message = ansiColorPrefix + (String)message;
            MOD_LOGGER.info((String)message, args);
        } else {
            MOD_LOGGER.debug((String)message, args);
        }
    }

    public static void info(String message, Object ... args) {
        message = LogUtil.attachSourceModulePrefix(message);
        MOD_LOGGER.info(message, args);
    }

    public static void warn(String message, Object ... args) {
        message = LogUtil.attachSourceModulePrefix(message);
        MOD_LOGGER.warn(message, args);
    }

    public static void error(String message, Object ... args) {
        message = LogUtil.attachSourceModulePrefix(message);
        MOD_LOGGER.error(message, args);
    }

    public static void disabled(String message, Object ... args) {
    }

    public static void stdout(String message, Object ... args) {
        System.out.printf(message, args);
    }

    public static class AnsiColor {
        public static final String RESET = "\u001b[0m";
        public static final String BLACK = "\u001b[30m";
        public static final String RED = "\u001b[31m";
        public static final String GREEN = "\u001b[32m";
        public static final String YELLOW = "\u001b[33m";
        public static final String BLUE = "\u001b[34m";
        public static final String MAGENTA = "\u001b[35m";
        public static final String CYAN = "\u001b[36m";
        public static final String WHITE = "\u001b[37m";

        @NotNull
        public static String wrapAnsiColorCode(@NotNull String contentString, @NotNull String ansiColorCode) {
            contentString = ansiColorCode + (String)contentString + RESET;
            return contentString;
        }
    }
}

