/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_scheduler.structure;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import lombok.Generated;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.RandomUtil;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.module.initializer.command_scheduler.CommandSchedulerInitializer;

public class CommandSchedulerJobDescriptor {
    private boolean enable;
    @Document(id=1751826743418L, value="The `unique` name of this `job`.\n")
    private String name;
    @Document(id=1751826745342L, value="Allowed left times to run.\n")
    @SerializedName(value="remaining_runs", alternate={"left_trigger_times", "left_times"})
    private int remainingRuns;
    @Document(id=1751826746949L, value="Defined `cron` expression list.\n\nAny met `cron` expression can `trigger` this `job`.\n")
    @SerializedName(value="schedules", alternate={"crons"})
    private List<String> schedules;
    @Document(id=1751826749083L, value="The commands to execute when the `job` is `triggered`.\n")
    @SerializedName(value="command_groups", alternate={"commands_list", "commands_groups"})
    private List<List<String>> command_groups;

    public void tryTrigger() {
        if (!this.enable) {
            return;
        }
        if (this.remainingRuns <= 0) {
            return;
        }
        --this.remainingRuns;
        CommandSchedulerInitializer.scheduler.writeStorage();
        List<String> commands = RandomUtil.drawList(this.command_groups);
        LogUtil.info("Execute commands in job `{}`: {}", this.getName(), commands);
        ServerHelper.executeSync(() -> CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(CommandHelper.Source.getConsoleCommandSource()), commands));
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getRemainingRuns() {
        return this.remainingRuns;
    }

    @Generated
    public List<String> getSchedules() {
        return this.schedules;
    }

    @Generated
    public List<List<String>> getCommand_groups() {
        return this.command_groups;
    }

    @Generated
    public CommandSchedulerJobDescriptor setEnable(boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public CommandSchedulerJobDescriptor setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public CommandSchedulerJobDescriptor setRemainingRuns(int remainingRuns) {
        this.remainingRuns = remainingRuns;
        return this;
    }

    @Generated
    public CommandSchedulerJobDescriptor setSchedules(List<String> schedules) {
        this.schedules = schedules;
        return this;
    }

    @Generated
    public CommandSchedulerJobDescriptor setCommand_groups(List<List<String>> command_groups) {
        this.command_groups = command_groups;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandSchedulerJobDescriptor)) {
            return false;
        }
        CommandSchedulerJobDescriptor other = (CommandSchedulerJobDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.getRemainingRuns() != other.getRemainingRuns()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$schedules = this.getSchedules();
        List<String> other$schedules = other.getSchedules();
        if (this$schedules == null ? other$schedules != null : !((Object)this$schedules).equals(other$schedules)) {
            return false;
        }
        List<List<String>> this$command_groups = this.getCommand_groups();
        List<List<String>> other$command_groups = other.getCommand_groups();
        return !(this$command_groups == null ? other$command_groups != null : !((Object)this$command_groups).equals(other$command_groups));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommandSchedulerJobDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + this.getRemainingRuns();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $schedules = this.getSchedules();
        result = result * 59 + ($schedules == null ? 43 : ((Object)$schedules).hashCode());
        List<List<String>> $command_groups = this.getCommand_groups();
        result = result * 59 + ($command_groups == null ? 43 : ((Object)$command_groups).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CommandSchedulerJobDescriptor(enable=" + this.isEnable() + ", name=" + this.getName() + ", remainingRuns=" + this.getRemainingRuns() + ", schedules=" + String.valueOf(this.getSchedules()) + ", command_groups=" + String.valueOf(this.getCommand_groups()) + ")";
    }

    @Generated
    public CommandSchedulerJobDescriptor() {
    }

    @Generated
    public CommandSchedulerJobDescriptor(boolean enable, String name, int remainingRuns, List<String> schedules, List<List<String>> command_groups) {
        this.enable = enable;
        this.name = name;
        this.remainingRuns = remainingRuns;
        this.schedules = schedules;
        this.command_groups = command_groups;
    }
}

