/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_toolbox.nickname;

import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.annotation.CommandTarget;
import mod.fuji.core.command.argument.wrapper.impl.GreedyString;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.ModifyPlayerDisplayNameEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.command_toolbox.nickname.config.model.NicknameConfigModel;
import mod.fuji.module.initializer.command_toolbox.nickname.config.model.NicknameDataModel;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Document(id=1758032261807L, value="This module allows customization of the `display name` of a player.\n")
@ColorBox(id=1758032281065L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Using the `nickname` module with `Styled Chat` mod.\nSee: https://github.com/fuji-fabric/fuji/issues/489\n")
@CommandNode(value="nickname")
public class NicknameInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<NicknameDataModel> data = ObjectConfigurationHandler.ofModule("nickname.json", NicknameDataModel.class);
    public static final BaseConfigurationHandler<NicknameConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", NicknameConfigModel.class);

    private static String formatNickname(@NotNull class_3222 player, @NotNull String inputNickName) {
        String nicknameFormat = NicknameInitializer.config.model().nicknameFormat;
        nicknameFormat = TextHelper.Operators.getString(TextHelper.getTextByValue(player, nicknameFormat, new Object[0]));
        return nicknameFormat.formatted(inputNickName);
    }

    @Document(id=1751825221904L, value="Set the display name.")
    @CommandNode(value="set")
    private static int $set(@CommandSource @CommandTarget class_3222 player, GreedyString format) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        String $format = (String)format.getValue();
        $format = NicknameInitializer.formatNickname(player, $format);
        NicknameInitializer.data.model().format.player2format.put(playerName, $format);
        data.writeStorage();
        PlayerHelper.updateDisplayName(player);
        TextHelper.sendTextByKey(player, "nickname.set", new Object[0]);
        return 1;
    }

    @Document(id=1751825227207L, value="Clear the display name.")
    @CommandNode(value="reset")
    private static int $reset(@CommandSource @CommandTarget class_3222 player) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        NicknameInitializer.data.model().format.player2format.remove(playerName);
        data.writeStorage();
        PlayerHelper.updateDisplayName(player);
        TextHelper.sendTextByKey(player, "nickname.unset", new Object[0]);
        return 1;
    }

    @EventConsumer
    private static void modifyPlayerDisplayName(ModifyPlayerDisplayNameEvent event) {
        class_1657 player = event.getPlayer();
        String playerName = PlayerHelper.getPlayerName(player);
        String preferredNicknameFormat = NicknameInitializer.data.model().format.player2format.get(playerName);
        if (preferredNicknameFormat != null) {
            class_2561 newValue = TextHelper.getTextByValue(null, preferredNicknameFormat, new Object[0]);
            event.setText(newValue);
        }
    }
}

