/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.jail.command.argument.adapter;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import mod.fuji.core.command.argument.structure.CommandArgument;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import mod.fuji.module.initializer.jail.service.JailService;
import mod.fuji.module.initializer.jail.structure.JailDescriptor;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

public class JailDescriptorArgumentTypeAdapter
extends BaseArgumentTypeAdapter {
    @Override
    protected ArgumentType<?> makeArgumentType() {
        return StringArgumentType.string();
    }

    @Override
    protected Object makeArgumentValue(@NotNull CommandContext<class_2168> context, @NotNull CommandArgument commandArgument) {
        String jailId = StringArgumentType.getString(context, (String)commandArgument.getArgumentName());
        Optional<JailDescriptor> jailDescriptor = JailService.findJailDescriptor(jailId);
        return jailDescriptor.orElseThrow(() -> {
            TextHelper.sendTextByKey(context.getSource(), "jail.not_found", jailId);
            return new AbortCommandExecutionException();
        });
    }

    @Override
    public List<Class<?>> getTypeClasses() {
        return List.of(JailDescriptor.class);
    }

    @Override
    public List<String> getTypeNames() {
        return List.of("jail-id");
    }

    @Override
    @NotNull
    protected RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(@NotNull String argumentName) {
        return super.makeRequiredArgumentBuilder(argumentName).suggests(CommandHelper.Suggestion.iterable(JailService::getJailIds));
    }
}

