/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.module;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.config.Configs;
import mod.fuji.core.event.graph.structure.EventConsumerInfo;
import mod.fuji.core.event.injector.StaticEventConsumerInjector;
import mod.fuji.core.module.ModulePathResolver;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

public class ModuleLoadDeterminer {
    public static final String ENABLE_JSON_KEY = "enable";
    private static final String MODULES_JSON_KEY = "modules";
    public static final Map<List<String>, Boolean> MODULE_ENABLE_STATUS = new HashMap<List<String>, Boolean>();

    @NotNull
    public static List<String> getEnabledModulePaths() {
        ArrayList<String> enabledModulePathStrings = new ArrayList<String>();
        MODULE_ENABLE_STATUS.forEach((module, enable) -> {
            if (enable.booleanValue()) {
                enabledModulePathStrings.add(ModulePathResolver.toModulePathString(module));
            }
        });
        enabledModulePathStrings.sort(String::compareTo);
        return enabledModulePathStrings;
    }

    @NotNull
    public static List<String> getDeclaredModulePaths() {
        return MODULE_ENABLE_STATUS.keySet().stream().map(ModulePathResolver::toModulePathString).toList();
    }

    public static boolean shouldLoadThis(@NotNull String className) {
        if (StaticEventConsumerInjector.getEventProducerMixinClassNames().contains(className)) {
            return ModuleLoadDeterminer.shouldLoadOnDemandEventMixin(className);
        }
        List<String> modulePathList = ModulePathResolver.toModulePathList(ModulePathResolver.computeModulePathString(className));
        return ModuleLoadDeterminer.shouldLoadModulePathList(modulePathList);
    }

    private static boolean shouldLoadOnDemandEventMixin(@NotNull String mixinClassName) {
        List<EventConsumerInfo> validConsumers = ReflectionUtil.CompileTimeGraph.getEventGraph().resolveConsumers(mixinClassName).stream().filter(eventConsumerInfo -> ModuleLoadDeterminer.shouldLoadThis(eventConsumerInfo.getDeclaringClassName())).toList();
        if (validConsumers.isEmpty()) {
            LogUtil.debug("Skip applying the on-demand event mixin '{}', there are no consumers.", mixinClassName);
            return false;
        }
        LogUtil.debug("Apply the on-demand event mixin '{}', to satisfy the consumers: {}", mixinClassName, validConsumers);
        return true;
    }

    private static boolean shouldLoadModulePathList(@NotNull List<String> modulePathList) {
        if (modulePathList.get(0).equals("core")) {
            return true;
        }
        if (Configs.MAIN_CONTROL_CONFIG.model().core.debug.disable_all_modules) {
            return false;
        }
        if (MODULE_ENABLE_STATUS.containsKey(modulePathList)) {
            return MODULE_ENABLE_STATUS.get(modulePathList);
        }
        boolean enable = true;
        JsonObject parent = Configs.MAIN_CONTROL_CONFIG.getModelAsJsonTree().get(MODULES_JSON_KEY).getAsJsonObject();
        for (String jsonKey : modulePathList) {
            if ((parent = parent.getAsJsonObject(jsonKey)) == null || !parent.has(ENABLE_JSON_KEY)) {
                throw new RuntimeException("Missing `enable` json key for module path list `%s`".formatted(modulePathList));
            }
            if (parent.getAsJsonPrimitive(ENABLE_JSON_KEY).getAsBoolean()) continue;
            enable = false;
            break;
        }
        if (!ModuleLoadDeterminer.isRequiredModsInstalled(modulePathList)) {
            LogUtil.debug("Refuse to enable module {} (Reason: the required dependency mod for this module isn't installed)", modulePathList);
            enable = false;
        }
        MODULE_ENABLE_STATUS.put(modulePathList, enable);
        return enable;
    }

    private static boolean isRequiredModsInstalled(@NotNull List<String> modulePath) {
        if (modulePath.contains("carpet")) {
            return FabricLoader.getInstance().isModLoaded("carpet");
        }
        return true;
    }
}

