/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.head.gui;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.List;
import mod.fuji.core.auxiliary.StringUtil;
import mod.fuji.core.auxiliary.minecraft.ItemStackHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.gui.component.gui.PagedGui;
import mod.fuji.module.initializer.head.HeadInitializer;
import mod.fuji.module.initializer.head.structure.EconomyType;
import mod.fuji.module.initializer.head.structure.Head;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CategoryHeadsGui
extends PagedGui<Head> {
    public CategoryHeadsGui(SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<Head> entities, int pageIndex) {
        super(parent, player, title, entities, pageIndex);
    }

    @Override
    @NotNull
    protected PagedGui<Head> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<Head> entities, int pageIndex) {
        return new CategoryHeadsGui(parent, player, title, entities, pageIndex);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull Head entity) {
        GuiElementBuilder builder = GuiElementBuilder.from((class_1799)entity.toItemStack());
        if (HeadInitializer.config.model().economy_type != EconomyType.FREE) {
            builder.addLoreLine((class_2561)class_2561.method_43473());
            builder.addLoreLine((class_2561)TextHelper.getTextByKey(this.getPlayer(), "head.price", new Object[0]).method_27661().method_10852(EconomyType.getCostText()));
        }
        builder.setCallback((index, type, action) -> this.handleEntityClick(entity, type));
        return builder.build();
    }

    @Override
    protected boolean filterEntity(@NotNull Head entity, @NotNull String keywords) {
        return StringUtil.containsIgnoreCase(entity.name, keywords) || StringUtil.containsIgnoreCase(entity.getTagsOrEmpty(), keywords);
    }

    private void handleEntityClick(@NotNull Head head, @NotNull ClickType type) {
        class_3222 player = this.getPlayer();
        class_1799 cursorStack = player.field_7512.method_34255();
        class_1799 headStack = head.toItemStack();
        if (cursorStack.method_7960()) {
            if (type.shift) {
                EconomyType.tryPurchaseHeads(player, 1, () -> player.method_31548().method_7394(headStack));
            } else if (type.isMiddle) {
                EconomyType.tryPurchaseHeads(player, headStack.method_7914(), () -> {
                    headStack.method_7939(headStack.method_7914());
                    player.field_7512.method_34254(headStack);
                });
            } else {
                EconomyType.tryPurchaseHeads(player, 1, () -> player.field_7512.method_34254(headStack));
            }
        } else if (ItemStackHelper.canCombine(headStack, cursorStack)) {
            if (type.isLeft) {
                EconomyType.tryPurchaseHeads(player, 1, () -> cursorStack.method_7933(1));
            } else if (type.isRight) {
                if (HeadInitializer.config.model().economy_type == EconomyType.FREE) {
                    cursorStack.method_7934(1);
                }
            } else if (type.isMiddle) {
                int amount = headStack.method_7914() - cursorStack.method_7947();
                EconomyType.tryPurchaseHeads(player, amount, () -> {
                    headStack.method_7939(headStack.method_7914());
                    player.field_7512.method_34254(headStack);
                });
            }
        }
    }
}

