/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.command.descriptor;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import mod.fuji.core.command.argument.structure.CommandArgument;
import mod.fuji.core.command.descriptor.ConsoleSpammer;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import mod.fuji.core.command.extension.CommandNodeExtension;
import mod.fuji.core.command.structure.CommandRequirementDescriptor;
import mod.fuji.core.command.structure.RegisteredCommandNode;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.document.descriptor.PermissionDescriptor;
import mod.fuji.core.document.interfaces.SourceModuleGetter;
import mod.fuji.core.module.ModulePathResolver;
import mod.fuji.core.structure.Pair;
import mod.fuji.core.structure.SpecialVariable;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandDescriptor
implements SourceModuleGetter,
ConsoleSpammer {
    public static final Set<CommandDescriptor> REGISTERED_COMMAND_DESCRIPTORS = ConcurrentHashMap.newKeySet();
    public static final Set<String> PUBLIC_COMMAND_PATHS = new HashSet<String>();
    private static final String SILENT_LITERAL = "silent";
    private static final String STDOUT_LITERAL = "stdout";
    public static final SpecialVariable<Boolean> stdoutSpecialVariable = new SpecialVariable<Boolean>(false);
    public static final SpecialVariable<Boolean> silentSpecialVariable = new SpecialVariable<Boolean>(false);
    @NotNull
    public final Method method;
    @NotNull
    public final List<CommandArgument> commandArguments;
    public Optional<String> document = Optional.empty();
    private Optional<LiteralArgumentBuilder<class_2168>> registerReturnValue = Optional.empty();
    public Set<String> contributedPublicCommandPaths = new HashSet<String>();

    protected CommandDescriptor(@NotNull Method method, @NotNull List<CommandArgument> commandArguments) {
        this.method = method;
        this.commandArguments = commandArguments;
    }

    @NotNull
    public static List<CommandDescriptor> getCommandDescriptors() {
        return REGISTERED_COMMAND_DESCRIPTORS.stream().sorted(Comparator.comparing(CommandDescriptor::getUserFriendlyCommandSyntax)).toList();
    }

    @CanIgnoreReturnValue
    @NotNull
    public CommandDescriptor fillDocument(@NotNull Optional<String> document) {
        if (document.isEmpty()) {
            return this;
        }
        this.document = document;
        return this;
    }

    @CanIgnoreReturnValue
    @NotNull
    public CommandDescriptor fillDocument(@Nullable Document document) {
        if (document == null) {
            return this;
        }
        return this.fillDocument(document.value());
    }

    @CanIgnoreReturnValue
    @NotNull
    public CommandDescriptor fillDocument(@Nullable String document) {
        if (document == null) {
            return this;
        }
        this.document = Optional.of(document);
        return this;
    }

    public void register() {
        this.trySpamConsole(() -> LogUtil.info("Register {} command: {}", this.getClass().getSimpleName(), this.getUserFriendlyCommandSyntax()));
        LogUtil.debug("Register command: {}", this);
        this.registerNonOptionalArguments();
        this.registerOptionalArguments();
        REGISTERED_COMMAND_DESCRIPTORS.add(this);
    }

    @TestCase(action="Modify the `my-command` into `my-command-v2`, and issue `/fuji reload`.", targets={"The command descriptor should be able to un-register the old command node in the command tree, even the new command node has different structure compared to the old one."})
    public void unregister() {
        this.trySpamConsole(() -> LogUtil.info("Un-Register {} command: {}", this.getClass().getSimpleName(), this.getUserFriendlyCommandSyntax()));
        LogUtil.debug("Un-register command: {}", this);
        this.registerReturnValue.ifPresentOrElse($registerReturnValue -> {
            LiteralCommandNode navigationNode = $registerReturnValue.build();
            List<List<RegisteredCommandNode>> registeredCommandTree = CommandHelper.Tree.findCommandTree((CommandNode<class_2168>)navigationNode);
            if (registeredCommandTree.isEmpty()) {
                LogUtil.warn("The command '{}' not found in server command tree, ignoring its un-registration.", this.getUserFriendlyCommandSyntax());
                return;
            }
            LogUtil.debug("Un-register the command tree: {}", registeredCommandTree);
            registeredCommandTree.forEach(branch -> branch.forEach(CommandHelper.Tree::removeCommandTree));
        }, () -> LogUtil.warn("Failed to remove the registered command node from the server command tree, due to the register return value being null. (descriptor = {}) ", this));
        boolean removeAny = PUBLIC_COMMAND_PATHS.removeAll(this.contributedPublicCommandPaths);
        if (removeAny) {
            LogUtil.debug("Remove the command paths '{}' from public command paths.", this.contributedPublicCommandPaths);
        }
        REGISTERED_COMMAND_DESCRIPTORS.remove(this);
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Optional<String> getFlatCommandPath() {
        return this.registerReturnValue.map($registerReturnValue -> {
            LiteralCommandNode navigationNode = $registerReturnValue.build();
            return CommandHelper.Path.toFlatCommandPathString((CommandNode<class_2168>)navigationNode);
        });
    }

    @NotNull
    private static CommandNode<class_2168> findOptionalArgumentAnchor(@NotNull List<CommandArgument> commandArguments) {
        List<String> commandPath = commandArguments.stream().filter(CommandArgument::isCommandArgumentSpecifier).takeWhile(commandArgument -> !commandArgument.isOptional() && !commandArgument.isGreedyArgumentType()).map(CommandArgument::getArgumentName).toList();
        return CommandHelper.getCommandDispatcher().findNode(commandPath);
    }

    @NotNull
    protected List<CommandArgument> getMethodParameterSpecifiers() {
        return this.commandArguments.stream().filter(CommandArgument::isMethodParameterSpecifier).toList();
    }

    @NotNull
    protected List<CommandArgument> getCommandArguments() {
        return this.commandArguments;
    }

    @TestCase(action="Test the `optional argument` functionality.", targets={"Issue `/send-title @s --mainTitle \"main\"`", "Issue `/send-title @s --mainTitle \"main\" --subTitle \"sub\"`", "Issue `/send-title @s --subTitle \"sub\" --mainTitle \"main\"`"})
    @NotNull
    protected List<Object> makeMethodParameterValues(@NotNull CommandContext<class_2168> ctx) {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (CommandArgument commandArgument : this.getMethodParameterSpecifiers()) {
            try {
                Object parameterValue = BaseArgumentTypeAdapter.Registry.getTypeAdapter(commandArgument.getArgumentType()).makeParameterValue(ctx, commandArgument);
                parameterValues.add(parameterValue);
            }
            catch (Exception e) {
                if (CommandException.isOptionalArgumentNotSpecifiedException(e)) {
                    if (commandArgument.isOptional()) {
                        parameterValues.add(Optional.empty());
                        continue;
                    }
                    LogUtil.error("[Lose argument values after command redirect]\nThe `argument values` are lost after a command redirect.\nRelated issue: https://github.com/Sinytra/Connector/issues/214\n\nYou should open an issue in https://github.com/fuji-fabric/fuji if you see this.\n", new Object[0]);
                    throw new IllegalArgumentException("Lose argument values after command redirect.");
                }
                throw e;
            }
        }
        return parameterValues;
    }

    protected Optional<Integer> findMethodParameterSpecifierIndex(@NotNull Predicate<CommandArgument> predicate) {
        List<CommandArgument> parameterSpecifiers = this.getMethodParameterSpecifiers();
        for (int i = 0; i < parameterSpecifiers.size(); ++i) {
            CommandArgument commandArgument = parameterSpecifiers.get(i);
            if (!predicate.test(commandArgument)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    protected Optional<Integer> findCommandArgumentIndex(@NotNull Predicate<CommandArgument> predicate) {
        List<CommandArgument> commandArguments = this.getCommandArguments();
        for (int i = 0; i < commandArguments.size(); ++i) {
            CommandArgument commandArgument = commandArguments.get(i);
            if (!predicate.test(commandArgument)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    protected Optional<Integer> findCommandSourceMethodParameterSpecifierIndex() {
        return this.findMethodParameterSpecifierIndex(CommandArgument::isCommandSource);
    }

    protected Optional<Integer> findCommandTargetMethodParameterSpecifierIndex() {
        return this.findMethodParameterSpecifierIndex(CommandArgument::isCommandTarget);
    }

    @NotNull
    protected Command<class_2168> makeCommandAction() {
        return this.withBaseCommandAction(commandContext -> {
            try {
                List<Object> parameterValues = this.makeMethodParameterValues((CommandContext<class_2168>)commandContext);
                int commandReturnValue = (Integer)this.method.invoke(null, parameterValues.toArray());
                return commandReturnValue;
            }
            catch (Exception wrappedOrUnwrappedException) {
                return CommandException.handleCommandExecutionException((CommandContext<class_2168>)commandContext, this.method, wrappedOrUnwrappedException);
            }
        });
    }

    @NotNull
    protected final Command<class_2168> withBaseCommandAction(@NotNull Function<CommandContext<class_2168>, Integer> commandAction) {
        return commandContext -> {
            AtomicInteger commandReturnValue = new AtomicInteger();
            Boolean stdoutFlag = CommandHelper.Context.tryGetArgument(commandContext, STDOUT_LITERAL, Boolean.class).orElse(stdoutSpecialVariable.get());
            Boolean silentFlag = CommandHelper.Context.tryGetArgument(commandContext, SILENT_LITERAL, Boolean.class).orElse(silentSpecialVariable.get());
            stdoutSpecialVariable.bind(stdoutFlag, () -> silentSpecialVariable.bind(silentFlag, () -> {
                if (!CommandSource.verifyCommandSource((CommandContext<class_2168>)commandContext, this)) {
                    commandReturnValue.set(0);
                    return;
                }
                int apply = (Integer)commandAction.apply(commandContext);
                commandReturnValue.set(apply);
            }));
            return commandReturnValue.get();
        };
    }

    private void registerNonOptionalArguments() {
        List<ArgumentBuilder<class_2168, ?>> argumentBuilders = ArgumentBuilderMaker.makeNonOptionalArgumentBuilders(this);
        LiteralArgumentBuilder<class_2168> assembledArgumentBuilder = ArgumentBuilderMaker.assembleArgumentBuilders(argumentBuilders, this::terminalArgumentDecorator);
        LiteralCommandNode literalCommandNode = assembledArgumentBuilder.build();
        RootCommandNode<class_2168> rootCommandNode = CommandHelper.Tree.getRootCommandNode();
        if (CommandHelper.Tree.isCommandNodeRegistered((CommandNode<class_2168>)literalCommandNode)) {
            LogUtil.warn("The command '{}' already registered in the server command tree, now overriding it.", this.getUserFriendlyCommandSyntax());
        }
        CommandHelper.Tree.replaceChild(rootCommandNode, (CommandNode<class_2168>)literalCommandNode);
        this.registerReturnValue = Optional.of(assembledArgumentBuilder);
    }

    @NotNull
    protected ArgumentBuilder<class_2168, ?> terminalArgumentDecorator(@NotNull ArgumentBuilder<class_2168, ?> terminalArgumentBuilder) {
        Command<class_2168> commandAction = this.makeCommandAction();
        return terminalArgumentBuilder.executes(commandAction);
    }

    private void registerOptionalArguments() {
        CommandNode<class_2168> redirectTargetNode = CommandDescriptor.findOptionalArgumentAnchor(this.commandArguments);
        this.commandArguments.stream().filter(CommandArgument::isOptional).forEach(optionalArgument -> CommandDescriptor.registerOptionalArgument(optionalArgument, redirectTargetNode));
        CommandRequirementDescriptor requirement = new CommandRequirementDescriptor(4, null);
        CommandDescriptor.registerOptionalArgument(CommandArgument.ofRequiredArgument(Boolean.class, SILENT_LITERAL, true, requirement), redirectTargetNode);
        CommandDescriptor.registerOptionalArgument(CommandArgument.ofRequiredArgument(Boolean.class, STDOUT_LITERAL, true, requirement), redirectTargetNode);
    }

    private static void registerOptionalArgument(@NotNull CommandArgument optionalArgument, @NotNull CommandNode<class_2168> redirectTargetNode) {
        CommandArgument leadingLiteralArgument = CommandArgument.ofLiteralArgument(CommandDescriptor.getOptionalArgumentLeadingArgumentName(optionalArgument.getArgumentName()), optionalArgument.getRequirement());
        Predicate<class_2168> requirementPredicate = CommandRequirement.makeCommandRequirementPredicate(optionalArgument.getRequirement());
        ArgumentBuilder optionalArgumentBuilder = ((LiteralArgumentBuilder)ArgumentBuilderMaker.makeLiteralArgumentBuilder(leadingLiteralArgument).requires(requirementPredicate)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)ArgumentBuilderMaker.makeRequiredArgumentBuilder(optionalArgument).requires(requirementPredicate)).executes(redirectTargetNode.getCommand())).redirect(redirectTargetNode));
        redirectTargetNode.addChild(optionalArgumentBuilder.build());
    }

    @NotNull
    protected static String getOptionalArgumentLeadingArgumentName(@NotNull String argumentName) {
        return "--" + argumentName;
    }

    @Override
    public boolean isConsoleSpammer() {
        return true;
    }

    public boolean canBeExecutedByConsole() {
        return this.commandArguments.stream().filter(CommandArgument::isCommandSource).allMatch(commandArgument -> commandArgument.getArgumentType().equals(CommandContext.class) || commandArgument.getArgumentType().equals(class_2168.class));
    }

    public String toString() {
        return this.getDetailedCommandSyntax();
    }

    @NotNull
    private String getDetailedCommandSyntax() {
        return "/" + this.commandArguments.stream().map(CommandArgument::toString).collect(Collectors.joining(" "));
    }

    @NotNull
    public String getUserFriendlyCommandSyntax() {
        return "/" + this.commandArguments.stream().filter(CommandArgument::isCommandArgumentSpecifier).map(CommandArgument::toFriendlyString).collect(Collectors.joining(" "));
    }

    @Override
    public String getSourceModule() {
        return ModulePathResolver.computeModulePathString(this.method.getDeclaringClass().getName());
    }

    public static class CommandException {
        public static final int COMMAND_EXCEPTION_COLOR_INT = 0xFF5F00;

        public static int handleCommandExecutionException(@NotNull CommandContext<class_2168> context, @NotNull Method method, @NotNull Throwable throwable) {
            if (throwable instanceof InvocationTargetException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof AbortCommandExecutionException) {
                return 0;
            }
            boolean isCommandSyntaxException = throwable instanceof CommandSyntaxException;
            if (isCommandSyntaxException) {
                throw throwable;
            }
            CommandException.handleNonCommandSyntaxException(context, method, throwable);
            return 0;
        }

        private static void handleNonCommandSyntaxException(@NotNull CommandContext<class_2168> context, @NotNull Method method, @NotNull Throwable throwable) {
            class_2168 source = (class_2168)context.getSource();
            String nonCommandSyntaxErrorString = "[Command Execution Failed]\n- From Module: %s\n- Command String: /%s\n- Command Source: %s\n- Message: %s\n\n".formatted(ModulePathResolver.computeModulePathString(method.getDeclaringClass().getName()), TextHelper.Parsers.escapeTags(context.getInput()), source.method_9214(), throwable);
            LogUtil.error(nonCommandSyntaxErrorString, throwable);
            class_2583 errorTextStyle = class_2583.field_24360.method_36139(0xFF5F00);
            if (CommandHelper.Requirement.isAdmin(source)) {
                String stacktrace = String.join((CharSequence)"\n", ReflectionUtil.extractStackTraceElements(throwable));
                errorTextStyle = errorTextStyle.method_10949(TextHelper.Events.HoverEvent.makeShowTextAction(class_2561.method_30163((String)"Click to copy the stacktrace."))).method_10958(TextHelper.Events.ClickEvent.makeCopyToClipboardAction(stacktrace));
            }
            class_5250 errorText = TextHelper.getTextByValue(source, nonCommandSyntaxErrorString, new Object[0]).method_27661().method_10862(errorTextStyle);
            source.method_45068((class_2561)errorText);
        }

        private static boolean isOptionalArgumentNotSpecifiedException(@NotNull Exception e) {
            return e.getMessage() != null && e.getMessage().startsWith("No such argument");
        }
    }

    private static class ArgumentBuilderMaker {
        private ArgumentBuilderMaker() {
        }

        @NotNull
        private static LiteralArgumentBuilder<class_2168> makeLiteralArgumentBuilder(@NotNull CommandArgument commandArgument) {
            if (!commandArgument.isLiteralArgument()) {
                throw new IllegalArgumentException("The command argument must be literal argument.");
            }
            return class_2170.method_9247((String)commandArgument.getArgumentName());
        }

        @NotNull
        private static RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(@NotNull CommandArgument commandArgument) {
            if (!commandArgument.isRequiredArgument()) {
                throw new IllegalArgumentException("The command argument must be required argument.");
            }
            return BaseArgumentTypeAdapter.Registry.getTypeAdapter(commandArgument.getArgumentType()).makeComposedRequiredArgumentBuilder(commandArgument.getArgumentName());
        }

        @NotNull
        private static LiteralArgumentBuilder<class_2168> assembleArgumentBuilders(@NotNull List<ArgumentBuilder<class_2168, ?>> builders, @NotNull Function<ArgumentBuilder<class_2168, ?>, ArgumentBuilder<class_2168, ?>> terminalArgumentDecorator) {
            ArgumentBuilder<class_2168, ?> root = null;
            for (int i = builders.size() - 1; i >= 0; --i) {
                ArgumentBuilder<class_2168, ?> node = builders.get(i);
                if (root == null) {
                    root = node;
                    root = terminalArgumentDecorator.apply(root);
                    continue;
                }
                root = node.then(root);
            }
            if (!(root instanceof LiteralArgumentBuilder)) {
                throw new IllegalArgumentException("The first argument builder must be a literal argument builder.");
            }
            return (LiteralArgumentBuilder)root;
        }

        @NotNull
        private static ArgumentBuilder<class_2168, ?> makeArgumentBuilder(@NotNull CommandArgument commandArgument) {
            Object builder = commandArgument.isRequiredArgument() ? ArgumentBuilderMaker.makeRequiredArgumentBuilder(commandArgument) : ArgumentBuilderMaker.makeLiteralArgumentBuilder(commandArgument);
            return builder;
        }

        private static List<ArgumentBuilder<class_2168, ?>> makeNonOptionalArgumentBuilders(@NotNull CommandDescriptor descriptor) {
            ArrayList pairs = new ArrayList();
            descriptor.commandArguments.stream().filter(it -> !it.isOptional() && it.isCommandArgumentSpecifier()).forEach(argument -> {
                ArgumentBuilder<class_2168, ?> builder = ArgumentBuilderMaker.makeArgumentBuilder(argument);
                pairs.add(new Pair(builder, (CommandArgument)argument));
            });
            CommandRequirement.fillCommandRequirement(pairs, descriptor);
            return pairs.stream().map(Pair::getKey).collect(Collectors.toList());
        }
    }

    public static class CommandRequirement {
        private static int computeLevelPermission(@NotNull CommandDescriptor descriptor) {
            int minRequiredLevel = CommandRequirementDescriptor.getInitialLevel();
            for (CommandArgument commandArgument : descriptor.commandArguments) {
                if (commandArgument.getRequirement() == null) continue;
                int permissionLevel = commandArgument.getRequirement().getLevel();
                minRequiredLevel = Math.max(minRequiredLevel, permissionLevel);
            }
            return minRequiredLevel;
        }

        @Nullable
        private static String computeStringPermission(@NotNull CommandDescriptor descriptor) {
            @Nullable String requiredString = CommandRequirementDescriptor.getInitialString();
            for (CommandArgument commandArgument : descriptor.commandArguments) {
                String permissionString;
                if (commandArgument.getRequirement() == null || (permissionString = commandArgument.getRequirement().getString()) == null || permissionString.isBlank()) continue;
                requiredString = permissionString;
                break;
            }
            return requiredString;
        }

        @NotNull
        public static CommandRequirementDescriptor computeCommandRequirement(@NotNull CommandDescriptor descriptor) {
            int levelPermission = CommandRequirement.computeLevelPermission(descriptor);
            String stringPermission = CommandRequirement.computeStringPermission(descriptor);
            return new CommandRequirementDescriptor(levelPermission, stringPermission);
        }

        @DocStringProvider(id=1751999362278L, value="The permission used as the default string permission, for a command descriptor.")
        @TestCase(action="Issue the `/warp` and `/back` command as normal user.", targets={"The default command permission should be registered properly.", "A public command, that shares a common command path prefix with another admin command, should be accessible to normal users."})
        private static void fillCommandRequirement(@NotNull List<Pair<ArgumentBuilder<class_2168, ?>, CommandArgument>> pairs, @NotNull CommandDescriptor descriptor) {
            Object walkingCommandPath = "";
            boolean seenAnyNonEmptyRequiremnt = false;
            for (Pair<ArgumentBuilder<class_2168, ?>, CommandArgument> pair : pairs) {
                ArgumentBuilder<class_2168, ?> argumentBuilder = pair.getKey();
                CommandArgument commandArgument = pair.getValue();
                walkingCommandPath = (String)walkingCommandPath + "." + commandArgument.getArgumentName();
                walkingCommandPath = CommandHelper.Path.trimCommandPathString((String)walkingCommandPath);
                if (!seenAnyNonEmptyRequiremnt && CommandRequirementDescriptor.isEmptyRequirement(commandArgument.getRequirement())) {
                    if (PUBLIC_COMMAND_PATHS.contains(walkingCommandPath)) continue;
                    LogUtil.debug("Add command path '{}' as the path of public command.", walkingCommandPath);
                    PUBLIC_COMMAND_PATHS.add((String)walkingCommandPath);
                    descriptor.contributedPublicCommandPaths.add((String)walkingCommandPath);
                    CommandHelper.Tree.findCommandNode((String)walkingCommandPath).ifPresent(registeredCommandNode -> {
                        CommandNodeExtension extension = (CommandNodeExtension)registeredCommandNode;
                        extension.fuji$setRequirement(source -> true);
                    });
                    continue;
                }
                seenAnyNonEmptyRequiremnt = true;
                if (PUBLIC_COMMAND_PATHS.contains(walkingCommandPath)) {
                    LogUtil.debug("Skip setting the requirement for the path of public command: {}", walkingCommandPath);
                    continue;
                }
                CommandRequirementDescriptor requirement = CommandRequirement.computeCommandRequirement(descriptor);
                Predicate<class_2168> predicate = CommandRequirement.makeCommandRequirementPredicate(requirement);
                argumentBuilder.requires(predicate);
            }
        }

        @NotNull
        private static Predicate<class_2168> makeCommandRequirementPredicate(CommandRequirementDescriptor requirement) {
            return commandContext -> {
                class_3222 player = commandContext.method_44023();
                if (player == null) {
                    return true;
                }
                if (requirement.getString() != null && !requirement.getString().isEmpty() && LuckpermsHelper.hasPermission(player.method_5667(), new PermissionDescriptor(requirement.getString(), 1751999362278L), new Object[0])) {
                    return true;
                }
                return commandContext.method_9259(requirement.getLevel());
            };
        }
    }

    public static class CommandSource {
        protected static boolean verifyCommandSource(@NotNull CommandContext<class_2168> commandContext, @NotNull CommandDescriptor descriptor) {
            List<CommandArgument> expectedCommandSources = descriptor.commandArguments.stream().filter(CommandArgument::isCommandSource).toList();
            if (expectedCommandSources.isEmpty()) {
                return true;
            }
            if (expectedCommandSources.size() > 1) {
                throw new IllegalArgumentException("Expected ZERO or ONE argument as the command source: " + String.valueOf(descriptor));
            }
            return BaseArgumentTypeAdapter.Registry.getTypeAdapter(expectedCommandSources.get(0).getArgumentType()).verifyCommandSource(commandContext);
        }
    }
}

