/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_permission.service;

import com.mojang.brigadier.tree.CommandNode;
import java.util.function.Predicate;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.module.initializer.command_permission.structure.WrappedPredicate;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

public class CommandPermissionService {
    public static boolean verboseModeFlag = false;

    public static void processVerboseModeFeature(String askWhoForPermissionTestResult, class_2168 source, String commandPath, Tristate commandPermissionTestResult) {
        if (!verboseModeFlag) {
            return;
        }
        String explanationForPermissionTestResult = CommandPermissionService.makeExplanationForPermissionTestResult(commandPermissionTestResult);
        LogUtil.info("\n\u25c9 Command Source: {}\n\u25c9 Command Path of the Target Command: {}\n\u25c9 Ask who for permission test result: {}\n\u25c9 Permission Test Result: {}\n\u25c9 Explanation: {}\n", source.method_9214(), commandPath, askWhoForPermissionTestResult, commandPermissionTestResult, explanationForPermissionTestResult);
    }

    @NotNull
    private static String makeExplanationForPermissionTestResult(Tristate state) {
        String explanation = state == Tristate.UNDEFINED ? "The permission test result is UNDEFINED, it means command_permission module WILL NOT HANDLE this command. We simply fallback the requirement predicate of this command to its original predicate." : (state == Tristate.TRUE ? "The permission test result is TRUE, it means command_permission module WILL ALLOW the command source to use this command." : (state == Tristate.FALSE ? "The permission test result is FALSE, it means command_permission module WILL DIS-ALLOW the command source to use this command." : "I don't know why, but the value of Tristate is un-expected."));
        return explanation;
    }

    @NotNull
    public static WrappedPredicate<Object> makeWrappedPredicate(@NotNull CommandNode<class_2168> commandNode, @NotNull Predicate<Object> originalRequirement) {
        return new WrappedPredicate<Object>(commandNode, originalRequirement);
    }

    public static boolean canUseThisCommand(class_2168 source, Tristate permissionTestResult, @NotNull Predicate<Object> originalRequirement) {
        if (permissionTestResult != Tristate.UNDEFINED) {
            return permissionTestResult.asBoolean();
        }
        return originalRequirement.test(source);
    }

    public static void ensureCommandNodeRequirementIsWrapped() {
        LogUtil.debug("Ensure command nodes are wrapped.", new Object[0]);
        CommandHelper.Tree.getAllCommandNodes().forEach(CommandNode::getRequirement);
    }

    public static boolean isCommandNodeWrapped(CommandNode<class_2168> commandNode) {
        return commandNode.getRequirement() instanceof WrappedPredicate;
    }
}

