/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.sit;

import java.util.HashSet;
import java.util.Set;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.minecraft.EntityHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.auxiliary.minecraft.WorldHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.annotation.CommandTarget;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.Cite;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerInteractBlockPreEvent;
import mod.fuji.core.event.message.server.lifecycle.ServerStoppingEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.sit.config.model.SitConfigModel;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5431;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Cite(value={"https://github.com/BradBot1/FabricSit"})
@Document(id=1751826999379L, value="Provides a facility to sit on blocks.\n")
@TestCase(action="Issue `/sit` command while stepping on the `bed block`.", targets={"The raycast height should be proper."})
public class SitInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<SitConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", SitConfigModel.class);
    private static final class_243 CHAIR_ENTITY_OFFSET = new class_243(0.0, -1.375, 0.0);
    private static final Set<class_1297> SPAWNED_CHAIR_ENTITY_LIST = new HashSet<class_1297>();

    public static boolean canSitNow(class_3222 player) {
        return player.method_24828() && !player.method_5765() && !player.method_6113() && !player.method_5681() && !player.method_7325();
    }

    @Document(id=1751827002061L, value="Sit in current position.")
    @CommandNode(value="sit")
    private static int $sit(@CommandSource @CommandTarget class_3222 player) {
        class_2338 steppingBlockPos = player.method_23312();
        class_3218 serverWorld = PlayerHelper.getServerWorld(player);
        class_2680 steppingBlockState = serverWorld.method_8320(steppingBlockPos);
        if (!SitInitializer.canSitNow(player) || steppingBlockState.method_26215() || steppingBlockState.method_51176()) {
            TextHelper.sendTextByKey(player, "sit.fail", new Object[0]);
            return 0;
        }
        class_243 lookTarget = EntityHelper.getPos((class_1297)player).method_1031(0.5, 0.0, 0.5);
        class_1297 chairEntity = SitInitializer.spawnChairEntity((class_1937)serverWorld, steppingBlockPos, lookTarget);
        SPAWNED_CHAIR_ENTITY_LIST.add(chairEntity);
        EntityHelper.rideEntity((class_1297)player, chairEntity);
        return 1;
    }

    private static double computeSensibleLengthY(class_265 voxelShape) {
        double averageLengthY = voxelShape.method_1090().stream().mapToDouble(it -> it.method_17940()).average().orElse(0.0);
        return averageLengthY;
    }

    @NotNull
    public static class_1297 spawnChairEntity(@NotNull class_1937 world, final @NotNull class_2338 targetBlockPos, @Nullable class_243 lookingTarget) {
        class_243 chairEntityPosition = WorldHelper.toBottomCenterPos(targetBlockPos).method_1031(0.0, 0.5, 0.0).method_1019(CHAIR_ENTITY_OFFSET);
        class_2680 targetBlockState = world.method_8320(targetBlockPos);
        class_265 outlineShape = targetBlockState.method_26218((class_1922)world, targetBlockPos);
        final double averageLengthY = SitInitializer.computeSensibleLengthY(outlineShape);
        if (!class_2248.method_9501((class_265)outlineShape, (class_2350)class_2350.field_11036)) {
            chairEntityPosition = chairEntityPosition.method_1031(0.0, -(1.0 - averageLengthY), 0.0);
        }
        class_1531 chairEntity = new class_1531(world, chairEntityPosition.field_1352, chairEntityPosition.field_1351, chairEntityPosition.field_1350){
            private boolean hasPassenger;
            private class_243 dismountOffset;
            {
                super(world, d, e, f);
                this.hasPassenger = false;
                this.dismountOffset = new class_243(0.0, averageLengthY, 0.0);
            }

            public void method_5627(class_1297 passenger) {
                super.method_5627(passenger);
                this.hasPassenger = true;
            }

            public boolean method_66249() {
                return false;
            }

            public boolean method_30632(class_2338 blockPos, class_2680 blockState) {
                return false;
            }

            private class_2338 getChairBlockPos() {
                return targetBlockPos;
            }

            private boolean isChairBlockBroken() {
                return EntityHelper.getServerWorld((class_1297)this).method_8320(this.getChairBlockPos()).method_26215();
            }

            private class_243 getDismountPosition() {
                return this.getChairBlockPos().method_46558().method_1019(this.dismountOffset);
            }

            public class_243 method_24829(class_1309 livingEntity) {
                return this.getDismountPosition();
            }

            protected void method_5793(class_1297 entity) {
                super.method_5793(entity);
                if (this.isChairBlockBroken()) {
                    class_243 dismountPosition = this.getDismountPosition();
                    entity.method_5808(dismountPosition.field_1352, dismountPosition.field_1351, dismountPosition.field_1350, entity.method_36454(), entity.method_36455());
                    EntityHelper.killEntity((class_1297)this);
                }
            }

            public void method_5773() {
                class_1297 passenger;
                if (this.hasPassenger && this.method_5685().isEmpty()) {
                    EntityHelper.killEntity((class_1297)this);
                }
                if (this.isChairBlockBroken()) {
                    EntityHelper.killEntity((class_1297)this);
                }
                if ((passenger = this.method_31483()) != null) {
                    this.method_36456(passenger.method_36454());
                    this.method_36457(passenger.method_36455());
                }
                super.method_5773();
            }
        };
        if (lookingTarget != null) {
            chairEntity.method_5702(class_2183.class_2184.field_9851, lookingTarget.method_1023(0.0, lookingTarget.method_10214() * 2.0, 0.0));
        }
        chairEntity.method_5648(true);
        chairEntity.method_5684(true);
        chairEntity.method_5665((class_2561)class_2561.method_43470((String)"FUJI-SIT"));
        chairEntity.method_5875(true);
        world.method_8649((class_1297)chairEntity);
        return chairEntity;
    }

    @EventConsumer
    private static void killSpawnedSitEntities(@Unused ServerStoppingEvent event) {
        SPAWNED_CHAIR_ENTITY_LIST.forEach(entity -> {
            if (entity.method_5805()) {
                EntityHelper.killEntity(entity);
            }
        });
    }

    @EventConsumer
    private static void consumePlayerInteractBlockPreEvent(PlayerInteractBlockPreEvent event) {
        if (event.getCallbackInfoReturnable().isCancelled()) {
            return;
        }
        class_3222 player = event.getPlayer();
        SitConfigModel config = SitInitializer.config.model();
        if (!config.right_click_to_sit.enable) {
            return;
        }
        if (!config.right_click_to_sit.allow_sneaking_to_sit && player.method_5715()) {
            return;
        }
        if (!SitInitializer.canSitNow(player)) {
            return;
        }
        if (config.right_click_to_sit.require_empty_hand_to_sit && !player.method_6047().method_7960()) {
            return;
        }
        class_1937 world = event.getWorld();
        class_3965 blockHitResult = event.getBlockHitResult();
        class_2338 hitBlockPos = blockHitResult.method_17777();
        class_2680 hitBlockState = world.method_8320(hitBlockPos);
        class_2248 hitBlock = hitBlockState.method_26204();
        if (config.right_click_to_sit.require_no_opaque_block_above_to_sit && world.method_8320(hitBlockPos.method_10069(0, 1, 0)).method_26225()) {
            return;
        }
        if (!(hitBlock instanceof class_2510) && !(hitBlock instanceof class_2482)) {
            return;
        }
        if (hitBlockState.method_30368((class_1922)world, hitBlockPos, class_2350.field_11036, class_5431.field_25824)) {
            return;
        }
        double maxDistanceToSit = config.right_click_to_sit.max_distance_to_sit;
        double givenDist = hitBlockPos.method_10262((class_2382)player.method_24515());
        if (maxDistanceToSit > 0.0 && givenDist > maxDistanceToSit * maxDistanceToSit) {
            return;
        }
        class_243 lookingTarget = EntityHelper.getPos((class_1297)player).method_1031(0.5, 0.0, 0.5);
        class_1297 chairEntity = SitInitializer.spawnChairEntity(world, hitBlockPos, lookingTarget);
        class_1297 currentVehicleEntity = player.method_5854();
        if (currentVehicleEntity != null) {
            PlayerHelper.dismountRidingEntity(player);
        }
        EntityHelper.rideEntity((class_1297)player, chairEntity);
        event.getCallbackInfoReturnable().setReturnValue((Object)class_1269.field_5812);
    }
}

