/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary.minecraft;

import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.StackHelper;
import io.github.sakurawald.core.command.exception.AbortCommandExecutionException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NbtHelper {
    private static <T extends class_2520> void setPath(@NotNull class_2487 root, @NotNull String path, T value) {
        String[] nodes = path.split("\\.");
        for (int i = 0; i < nodes.length - 1; ++i) {
            String node = nodes[i];
            if (!root.method_10545(node)) {
                root.method_10566(node, (class_2520)new class_2487());
            }
            root = NbtHelper.getCompound(root, node);
        }
        String key = nodes[nodes.length - 1];
        root.method_10566(key, value);
    }

    public static <T extends class_2520> T withNbtElement(@NotNull class_2487 root, @NotNull String path, T orElse) {
        if (NbtHelper.readPath(root, path) == null) {
            NbtHelper.setPath(root, path, orElse);
        }
        return (T)NbtHelper.readPath(root, path);
    }

    @Nullable
    private static class_2520 readPath(@NotNull class_2487 root, @NotNull String path) {
        String[] nodes = path.split("\\.");
        for (int i = 0; i < nodes.length - 1; ++i) {
            String node = nodes[i];
            if (!root.method_10545(node)) {
                LogUtil.error("Failed to read specified path {} in nbt {}. (Path not exists)", path, root);
            }
            root = NbtHelper.getCompound(root, node);
        }
        String key = nodes[nodes.length - 1];
        return root.method_10580(key);
    }

    public static class_2499 writeSlotsNode(@NotNull class_2499 node, @NotNull List<class_1799> stackList) {
        for (class_1799 stack : stackList) {
            node.add((Object)NbtHelper.toNbtAllowEmpty(stack, RegistryHelper.getDefaultWrapperLookup()));
        }
        return node;
    }

    public static class_2520 toNbtAllowEmpty(class_1799 stack, class_7225.class_7874 wrapperLookup) {
        if (stack.method_7960()) {
            return new class_2487();
        }
        return StackHelper.encodeAllowEmpty(stack, wrapperLookup);
    }

    public static class_1799 fromNbtOrEmpty(class_7225.class_7874 wrapperLookup, class_2487 nbtCompound) {
        if (nbtCompound.method_33133()) {
            return class_1799.field_8037;
        }
        return StackHelper.fromNbt(wrapperLookup, (class_2520)nbtCompound).orElse(class_1799.field_8037);
    }

    @NotNull
    public static List<class_1799> readSlotsNode(@Nullable class_2499 node) {
        if (node == null) {
            return new ArrayList<class_1799>();
        }
        ArrayList<class_1799> ret = new ArrayList<class_1799>();
        for (int i = 0; i < node.size(); ++i) {
            ret.add(NbtHelper.fromNbtOrEmpty(RegistryHelper.getDefaultWrapperLookup(), NbtHelper.getCompound(node, i)));
        }
        return ret;
    }

    public static void withNbtFile(@NotNull Path path, @NotNull Consumer<class_2487> function) {
        NbtHelper.withNbtFileAndGettingReturnValue(path, root -> {
            function.accept((class_2487)root);
            return null;
        });
    }

    private static void writeNbtFile(class_2487 nbt, Path path) {
        class_2507.method_10630((class_2487)nbt, (Path)path);
    }

    private static class_2487 readNbtFile(Path path) {
        return class_2507.method_10633((Path)path);
    }

    public static <T> T withNbtFileAndGettingReturnValue(@NotNull Path path, @NotNull Function<class_2487, T> function) {
        class_2487 read;
        if (Files.notExists(path, new LinkOption[0])) {
            NbtHelper.writeNbtFile(new class_2487(), path);
        }
        if ((read = NbtHelper.readNbtFile(path)) == null) {
            LogUtil.error("Failed to read the nbt file in {}", path);
            throw new AbortCommandExecutionException();
        }
        T value = function.apply(read);
        NbtHelper.writeNbtFile(read, path);
        return value;
    }

    @Nullable
    public static String getString(class_2487 root, String key) {
        return root.method_10558(key);
    }

    @Nullable
    public static class_2487 getCompound(class_2487 root, String key) {
        return root.method_10562(key);
    }

    @Nullable
    public static class_2487 getCompound(class_2499 list, int index) {
        return list.method_10602(index);
    }

    public static int getInt(class_2487 root, String key) {
        return root.method_10550(key);
    }

    public static float getFloat(class_2487 root, String key) {
        return root.method_10583(key);
    }

    public static double getDouble(class_2487 root, String key) {
        return root.method_10574(key);
    }

    @Nullable
    public static class_2487 getNbt(class_1799 stack) {
        class_9279 nbtComponent = (class_9279)stack.method_57824(class_9334.field_49628);
        return nbtComponent == null ? null : nbtComponent.method_57461();
    }

    public static void withNbt(class_1799 stack, Consumer<class_2487> nbtConsumer) {
        class_2487 targetNbt = NbtHelper.getNbt(stack);
        if (targetNbt == null) {
            targetNbt = new class_2487();
        }
        nbtConsumer.accept(targetNbt);
        NbtHelper.setNbt(stack, targetNbt);
    }

    public static void setNbt(class_1799 stack, class_2487 newNbt) {
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)newNbt));
    }

    private NbtHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

