/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.config.handler.abst;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.config.job.ConfigurationHandlerSaverJob;
import io.github.sakurawald.core.config.transformer.abst.ConfigurationTransformer;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDataMap;

public abstract class BaseConfigurationHandler<T> {
    public static final String CONFIG_JSON = "config.json";
    public static final Set<BaseConfigurationHandler<?>> handlers = new HashSet();
    protected static Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
    private static ParseContext jsonPathParser = null;
    @NotNull
    protected final Path path;
    private final List<ConfigurationTransformer> transformers = new ArrayList<ConfigurationTransformer>();
    protected T model;

    public BaseConfigurationHandler(@NotNull Path path) {
        this.path = path;
    }

    public static ParseContext getJsonPathParser() {
        if (jsonPathParser == null) {
            BaseConfigurationHandler.configureJsonPathLibrary();
            jsonPathParser = JsonPath.using((Configuration)Configuration.defaultConfiguration());
        }
        return jsonPathParser;
    }

    private static void configureJsonPathLibrary() {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){

            public JsonProvider jsonProvider() {
                return new GsonJsonProvider(gson);
            }

            public MappingProvider mappingProvider() {
                return new GsonMappingProvider(gson);
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }

    public static void registerTypeAdapter(Type type, Object typeAdapter) {
        gson = gson.newBuilder().registerTypeAdapter(type, typeAdapter).create();
    }

    public BaseConfigurationHandler<T> addTransformer(ConfigurationTransformer transformer) {
        this.transformers.add(transformer);
        return this;
    }

    protected abstract T getDefaultModel();

    public void readStorage() {
        block7: {
            try {
                this.transformers.forEach(it -> {
                    it.configure(this.path);
                    it.apply();
                });
                if (Files.notExists(this.path, new LinkOption[0])) {
                    this.writeStorage();
                    break block7;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.path.toFile())));
                try {
                    T defaultModel = this.getDefaultModel();
                    this.model = gson.fromJson((Reader)reader, defaultModel.getClass());
                    this.writeStorage();
                }
                finally {
                    if (Collections.singletonList(reader).get(0) != null) {
                        ((Reader)reader).close();
                    }
                }
            }
            catch (IOException e) {
                LogUtil.error("Failed to read configuration file {} from disk.", this.path, e);
            }
        }
        handlers.add(this);
    }

    public void beforeWriteStorage() {
    }

    public void writeStorage() {
        try {
            if (this.model == null) {
                this.model = this.getDefaultModel();
                LogUtil.info("Write default configuration: {}", this.path.toFile().getAbsolutePath());
            }
            this.beforeWriteStorage();
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            Files.writeString(this.path, (CharSequence)gson.toJson(this.model), new OpenOption[0]);
        }
        catch (IOException e) {
            LogUtil.error("Failed to write configuration file {} to disk.", this.path, e);
        }
    }

    public JsonElement convertModelToJsonTree() {
        return gson.toJsonTree(this.model());
    }

    private void scheduleWriteStorageJob(@NotNull String cron) {
        String jobName = this.path.toString();
        new ConfigurationHandlerSaverJob(jobName, new JobDataMap(){
            {
                this.put(BaseConfigurationHandler.class.getName(), BaseConfigurationHandler.this);
            }
        }, () -> cron).schedule();
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            LogUtil.debug("Write storage on server stopping: {}", this.path);
            this.writeStorage();
        });
    }

    public BaseConfigurationHandler<T> autoSaveEveryMinute() {
        this.scheduleWriteStorageJob("0 * * ? * * *");
        return this;
    }

    @NotNull
    public T model() {
        if (this.model == null) {
            this.readStorage();
        }
        if (this.model == null) {
            throw new IllegalStateException("The model of configuration file %s is null".formatted(this.path));
        }
        return this.model;
    }

    public static Gson getGson() {
        return gson;
    }

    @NotNull
    public Path getPath() {
        return this.path;
    }
}

