/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.manager.impl.callback;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.event.impl.CommandEvents;
import io.github.sakurawald.core.manager.abst.BaseManager;
import io.github.sakurawald.core.manager.impl.callback.structure.TTLMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_3222;

public class CallbackManager
extends BaseManager {
    private static final String COMMAND_CALLBACK = "command-callback";
    private final TTLMap<String, Consumer<class_3222>> uuid2consumer = new TTLMap();

    @Override
    public void onInitialize() {
        this.registerCLI();
    }

    private void registerCLI() {
        CommandEvents.REGISTRATION.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_CALLBACK).then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.greedyString()).executes(this::$executeCallback))));
    }

    private int $executeCallback(CommandContext<class_2168> ctx) {
        return CommandHelper.Pattern.playerOnlyCommand(ctx, player -> {
            String uuid = StringArgumentType.getString((CommandContext)ctx, (String)"uuid");
            this.executeCallback(uuid, (class_3222)player);
            return 1;
        });
    }

    private void executeCallback(String uuid, class_3222 player) {
        Consumer<class_3222> consumer = this.uuid2consumer.get(uuid);
        if (consumer == null) {
            TextHelper.sendMessageByKey(player, "callback.invalid", new Object[0]);
            return;
        }
        consumer.accept(player);
    }

    private String makeCallbackCommand(String uuid, Consumer<class_3222> callback, long ttl, TimeUnit timeUnit) {
        LogUtil.debug("Make command callback: uuid = {}", uuid);
        this.uuid2consumer.put(uuid, callback, ttl, timeUnit);
        return "/command-callback " + uuid;
    }

    private class_2558 makeCallbackEvent(String uuid, Consumer<class_3222> callback, long ttl, TimeUnit timeUnit) {
        return TextHelper.ClickEvent.makeRunCommandAction(this.makeCallbackCommand(uuid, callback, ttl, timeUnit));
    }

    public String makeCallbackCommand(Consumer<class_3222> callback, long ttl, TimeUnit timeUnit) {
        return this.makeCallbackCommand(UUID.randomUUID().toString(), callback, ttl, timeUnit);
    }

    public class_2558 makeCallbackEvent(Consumer<class_3222> callback, long ttl, TimeUnit timeUnit) {
        return this.makeCallbackEvent(UUID.randomUUID().toString(), callback, ttl, timeUnit);
    }
}

