/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.manager.impl.module;

import com.google.gson.JsonObject;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.config.Configs;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.core.manager.Managers;
import io.github.sakurawald.core.manager.abst.BaseManager;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.mixin.GlobalMixinConfigPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

public class ModuleManager
extends BaseManager {
    public static final String ENABLE_SUPPLIER_KEY = "enable";
    public static final String CORE_MODULE_ROOT = "core";
    private static final Set<String> MODULE_PATHS = new HashSet<String>(ReflectionUtil.getGraph("module-graph.txt"));
    private final Map<Class<? extends ModuleInitializer>, ModuleInitializer> moduleRegistry = new HashMap<Class<? extends ModuleInitializer>, ModuleInitializer>();
    private final Map<List<String>, Boolean> module2enable = new HashMap<List<String>, Boolean>();
    private static final Map<String, String> className2modulePathString = new HashMap<String, String>();

    public static String computeModulePathAsString(@NotNull String className) {
        String modulePathString = className2modulePathString.get(className);
        if (modulePathString != null) {
            return modulePathString;
        }
        String result = ModuleManager.joinModulePath(ModuleManager.computeModulePathAsList(className));
        className2modulePathString.put(className, result);
        return result;
    }

    @NotNull
    public static List<String> computeModulePathAsList(@NotNull String className) {
        if (MODULE_PATHS.isEmpty()) {
            LogUtil.warn("This is the first time we generating the module graph file, we just ", new Object[0]);
        }
        int left = -1;
        List<Class<GlobalMixinConfigPlugin>> modulePackagePrefixes = List.of(ModuleInitializer.class, GlobalMixinConfigPlugin.class);
        for (Class<GlobalMixinConfigPlugin> modulePackagePrefix : modulePackagePrefixes) {
            String prefix = modulePackagePrefix.getPackageName();
            if (!className.startsWith(prefix) || className.equals(modulePackagePrefix.getName())) continue;
            left = prefix.length() + 1;
            break;
        }
        if (left == -1) {
            return List.of(CORE_MODULE_ROOT);
        }
        String str = className.substring(left);
        int right = str.lastIndexOf(".");
        ArrayList<String> modulePath = new ArrayList<String>(List.of((str = str.substring(0, right)).split("\\.")));
        if (((String)modulePath.get(0)).equals(CORE_MODULE_ROOT)) {
            return List.of(CORE_MODULE_ROOT);
        }
        String modulePathString = String.join((CharSequence)".", modulePath);
        while (!MODULE_PATHS.contains(modulePathString)) {
            if (modulePath.isEmpty()) {
                throw new RuntimeException("Can't find the module enable-supplier in `config.json` for class name %s. Did you forget to add the enable-supplier key in ConfigModel ?".formatted(className));
            }
            modulePath.remove(modulePath.size() - 1);
            modulePathString = String.join((CharSequence)".", modulePath);
        }
        return modulePath;
    }

    public static String joinModulePath(List<String> modulePath) {
        return String.join((CharSequence)".", modulePath);
    }

    @Override
    public void onInitialize() {
        this.invokeModuleInitializers();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> this.serverStartupReport());
    }

    private void invokeModuleInitializers() {
        ReflectionUtil.getGraph("module-initializer-graph.txt").stream().filter(className -> Managers.getModuleManager().shouldWeEnableThis((String)className)).forEach(className -> {
            try {
                Class<?> clazz = Class.forName(className);
                this.initializeModuleInitializer(clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public <T extends ModuleInitializer> void initializeModuleInitializer(@NotNull Class<T> clazz) {
        if (!this.moduleRegistry.containsKey(clazz) && this.shouldWeEnableThis(clazz.getName())) {
            try {
                ModuleInitializer moduleInitializer = (ModuleInitializer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                moduleInitializer.doInitialize();
                this.moduleRegistry.put(clazz, moduleInitializer);
            }
            catch (Exception e) {
                LogUtil.error("Failed to invoke doInitialize() of module initializer of module {}", clazz.getSimpleName(), e);
            }
        }
    }

    public void reloadModuleInitializers() {
        this.moduleRegistry.values().forEach(initializer -> {
            try {
                initializer.doReload();
            }
            catch (Exception e) {
                LogUtil.error("Failed to reload module.", e);
            }
        });
    }

    private void serverStartupReport() {
        ArrayList enabledModuleList = new ArrayList();
        this.module2enable.forEach((module, enable) -> {
            if (enable.booleanValue()) {
                enabledModuleList.add(ModuleManager.joinModulePath(module));
            }
        });
        enabledModuleList.sort(String::compareTo);
        LogUtil.info("Enabled {}/{} modules -> {}", enabledModuleList.size(), this.module2enable.size(), enabledModuleList);
        if (enabledModuleList.size() == 1) {
            this.firstTimeHelper();
        }
    }

    private void firstTimeHelper() {
        LogUtil.info("\n[Fuji User Guide]\nIt seems that this is the first time you use fuji mod.\n\nHere are some important points:\n- Fuji is designed to be fully-modular, that is to say, all modules are disabled by default.\n- To enable a module, is just like ordering food at a restaurant: you can enable a module by modifying the `config/fuji/config.json` file, and re-start the server to apply the modification.\n    - To use `/tpa` command, enable the `tpa` module.\n    - To use placeholders provided by fuji, enable the `placeholder` module.\n    - To use echo commands like `/send-message`, `/send-broadcast` etc, enable the `echo` module.\n- To see the list of modules, and what functionality they provides, read the `fuji manual` pdf file in https://github.com/sakurawald/fuji/raw/dev/docs/release/fuji.pdf\n- Anything unclear, open an issue in https://github.com/sakurawald/fuji/issues\n", new Object[0]);
    }

    public boolean shouldWeEnableThis(String className) {
        return this.shouldWeEnableThis(ModuleManager.computeModulePathAsList(className));
    }

    private boolean shouldWeEnableThis(@NotNull List<String> modulePath) {
        if (Configs.configHandler.model().core.debug.disable_all_modules) {
            return false;
        }
        if (modulePath.get(0).equals(CORE_MODULE_ROOT)) {
            return true;
        }
        if (this.module2enable.containsKey(modulePath)) {
            return this.module2enable.get(modulePath);
        }
        boolean enable = true;
        JsonObject parent = Configs.configHandler.convertModelToJsonTree().getAsJsonObject().get("modules").getAsJsonObject();
        for (String node : modulePath) {
            if ((parent = parent.getAsJsonObject(node)) == null || !parent.has(ENABLE_SUPPLIER_KEY)) {
                throw new RuntimeException("missing `enable supplier` key for dir name list `%s`".formatted(modulePath));
            }
            if (parent.getAsJsonPrimitive(ENABLE_SUPPLIER_KEY).getAsBoolean()) continue;
            enable = false;
            break;
        }
        if (!this.isRequiredModsInstalled(modulePath)) {
            LogUtil.debug("Refuse to enable module {} (reason: the required dependency mod for this module isn't installed, please read the official wiki!)", modulePath);
            enable = false;
        }
        this.module2enable.put(modulePath, enable);
        return enable;
    }

    private boolean isRequiredModsInstalled(@NotNull List<String> modulePath) {
        if (modulePath.contains("carpet")) {
            return FabricLoader.getInstance().isModLoaded("carpet");
        }
        return true;
    }

    public Map<Class<? extends ModuleInitializer>, ModuleInitializer> getModuleRegistry() {
        return this.moduleRegistry;
    }

    public Map<List<String>, Boolean> getModule2enable() {
        return this.module2enable;
    }
}

